/*
 * $RCSfile: LoginDialog.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.login;

import java.lang.*;
import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents a login dialog controller.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:35 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class LoginDialog extends BasicController {

    //
    // Control id constants.
    //

    /** The create login dialog control id. */
    public static final String CREATE_LOGIN_DIALOG_CONTROL_ID = "create_login_dialog";

    /** The destroy login dialog control id. */
    public static final String DESTROY_LOGIN_DIALOG_CONTROL_ID = "destroy_login_dialog";

    //
    // View.
    //

    /**
     * Creates the view.
     *
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws NullPointerException {

        LoginDialogView v = new LoginDialogView();

        if (v != null) {

            ((LoginDialogView) v).initialize();

        } else {

            throw new NullPointerException("Could not create view. The view is null.");
        }

        return v;
    }

    /**
     * Destroys the view.
     *
     * @param v the view
     * @exception NullPointerException if the view is null
     */
    public void destroyView(View v) throws NullPointerException {

        if (v != null) {

            ((LoginDialogView) v).finalizz();

        } else {

            throw new NullPointerException("Could not destroy view. The view is null.");
        }
    }
}

