/*
 * $RCSfile: BasicController.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.basic;

import java.awt.event.*;
import java.lang.*;
import java.util.prefs.*;
import java.util.Hashtable;
import javax.swing.event.*;
import javax.swing.*;

import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.component.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.logger.*;
import org.resmedicinae.resmedlib.component.model.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

/**
 * This class represents a controller.
 *
 * A controller can control a model and a view, following the
 * Model-View-Controller (MVC) design pattern.
 * - the view gets data from the model and displays them
 * - the controller reacts on view events in the <code>handle</code> method
 * - the model gets manipulated by the controller and then sends an update event to the view
 *
 * Design patterns:
 * - Controller in Model View Controller
 *
 * @version $Revision: 1.15 $ $Date: 2002/09/19 17:57:51 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class BasicController extends Controller implements ActionListener, ItemListener, KeyListener, MouseMotionListener, MouseListener, ListSelectionListener, TreeSelectionListener, DocumentListener, FocusListener {

    //
    // Attributes.
    //

    /** The view. */
    private View view;

    /** The model. */
    private Object model;

    /** The view context. */
    private int viewContext;

    //
    // Display manager.
    //

    /**
     * Returns the display manager.
     *
     * @return the display manager
     */
    public DisplayManager getDisplayManager() {

        DisplayManager displayManager = null;
        ComponentManager m = getComponentManager();

        if (m != null) {

            displayManager = (DisplayManager) m.get(DisplayManager.ROLE);
        }

        return displayManager;
    }

    /**
     * Sets the display manager.
     *
     * @param displayManager the display manager
     * @exception NullPointerException if the component manager is null
     */
    public void setDisplayManager(DisplayManager displayManager) throws NullPointerException {

        ComponentManager m = getComponentManager();

        if (m != null) {

            m.add(displayManager);

        } else {

            throw new NullPointerException("Could not set display manager. The component manager is null.");
        }
    }

    //
    // Persistence manager.
    //

    /**
     * Returns the persistence manager.
     *
     * @return the persistence manager
     * @exception NullPointerException if the component manager is null
     */
    public PersistenceManager getPersistenceManager() throws NullPointerException {

        PersistenceManager persistenceManager = null;
        ComponentManager m = getComponentManager();

        if (m != null) {

            persistenceManager = (PersistenceManager) m.get(PersistenceManager.ROLE);

        } else {

            throw new NullPointerException("Could not get persistence manager. The component manager is null.");
        }

        return persistenceManager;
    }

    /**
     * Sets the persistence manager.
     *
     * @param persistenceManager the persistence manager
     * @exception NullPointerException if the component manager is null
     */
    public void setPersistenceManager(PersistenceManager persistenceManager) throws NullPointerException {

        ComponentManager m = getComponentManager();

        if (m != null) {

            m.add(persistenceManager);

        } else {

            throw new NullPointerException("Could not set persistence manager. The component manager is null.");
        }
    }

    //
    // View.
    //

    /**
     * Returns the view.
     *
     * @return the view
     */
    public View getView() {

        return this.view;
    }

    /**
     * Sets the view.
     *
     * The view is being linked to this controller's current model.
     *
     * @param view the view
     * @exception NullPointerException if the view is null
     */
    public void setView(View view) throws NullPointerException {

        if (view != this.view) {

            // Stores the old view.
            View oldView = this.view;

            if (oldView != null) {

                // Unlinks the old view from the model.
                bindViewToModel(oldView, null);
                oldView.setController(null);
            }

            if (view != null) {

                // Links the new view to the model.
                bindViewToModel(view, model);
                view.setController(this);
            }

            // Sets the new view.
            this.view = view;
        }
    }

    /**
     * Creates a view.
     *
     * Design patterns:
     * - Template method
     *
     * @return the view
     */
    public View createView() throws Exception {

        System.out.println("??? test 0");
        View v = null;
        int context = getViewContext();
        System.out.println("??? test 1: " + context);

        if (context == DisplayManager.TEXT) {

//??            v = createTextView();

        } else if (context == DisplayManager.SWING) {

            System.out.println("??? test 2: " + v);
            v = createSwingView();

        } else if (context == DisplayManager.JSP) {

//??            v = createJspView();

        } else {

            throw new Exception("Could not create view. The given view context does not exist.");
        }

        return v;
    }

    /**
     * Destroys the view.
     *
     * @param v the view
     */
    public void destroyView(View v) throws Exception {

        int context = getViewContext();

        if (context == DisplayManager.TEXT) {

//??            destroyTextView(v);

        } else if (context == DisplayManager.SWING) {

            destroySwingView((SwingView) v);

        } else if (context == DisplayManager.JSP) {

//??            destroyJspView(v);

        } else {

            throw new Exception("Could not destroy view. The given view context does not exist.");
        }
    }

    /**
     * Creates a text view.
     *
     * @return the text view
     */
/*??
    protected View createTextView() throws Exception {

        View v = new TextView();

        // Bring component through birth process.
//??        bear(v);

        //?? Temporary, until view inherits from Component one day...
        ((TextView) v).configure(getConfigurationManager());
        ((TextView) v).initialize();

        return v;
    }

    /**
     * Destroys the text view.
     *
     * @param v the text view
     */
/*??
    protected void destroyTextView(View v) throws Exception {

        // Bring component through death process.
//??        kill(v);

        //?? Temporary, until view inherits from Component one day...
        ((TextView) v).finalizz();
        ((TextView) v).deconfigure(getConfigurationManager());
    }

    /**
     * Creates a swing view.
     *
     * @return the swing view
     * @exception NullPointerException if the swing view is null
     */
    protected View createSwingView() throws Exception, NullPointerException {

        SwingView v = new SwingView();

        if (v != null) {

            v.setController(this);
            v.configure(getConfigurationManager());
            v.initialize();

        } else {

            throw new NullPointerException("Could not create swing view. The swing view is null.");
        }

        return v;
    }

    /**
     * Destroys the swing view.
     *
     * @param v the swing view
     * @exception NullPointerException if the swing view is null
     */
    protected void destroySwingView(SwingView v) throws Exception, NullPointerException {

        if (v != null) {

            v.finalizz();
            v.deconfigure(getConfigurationManager());
            v.setController(null);

        } else {

            throw new NullPointerException("Could not destroy swing view. The swing view is null.");
        }
    }

    /**
     * Creates a jsp view.
     *
     * @return the jsp view
     */
/*??
    protected View createJspView() throws Exception {

        View v = new JspView();

        // Bring component through birth process.
//??        bear(v);

        //?? Temporary, until view inherits from Component one day...
        ((JspView) v).configure(getConfigurationManager());
        ((JspView) v).initialize();

        return v;
    }

    /**
     * Destroys the jsp view.
     *
     * @param v the jsp view
     */
/*??
    protected void destroyJspView(View v) throws Exception {

        // Bring component through death process.
//??        kill(v);

        //?? Temporary, until view inherits from Component one day...
        ((JspView) v).finalizz();
        ((JspView) v).deconfigure(getConfigurationManager());
    }

    //
    // Model.
    //

    /**
     * Returns the model.
     *
     * @return the model
     */
    public Object getModel() {

        return this.model;
    }

    /**
     * Sets the model.
     *
     * The model is being linked to this controller's current view.
     *
     * @param model the model
     */
    public void setModel(Object model) {

        if (model != this.model) {

            // Links the model to the view.
            bindViewToModel(getView(), model);

            // Sets the new model.
            this.model = model;
        }
    }

    /**
     * Creates an application model.
     *
     * @return the application model
     * @exception NullPointerException if the application model is null
     */
    public Object createModel() throws Exception, NullPointerException {

        return null;
    }

    /**
     * Destroys the application model.
     *
     * @param m the application model
     * @exception NullPointerException if the application model is null
     */
    public void destroyModel(Object m) throws Exception, NullPointerException {
    }

    //
    // View model binding.
    //

    /**
     * Binds the view to the model.
     *
     * @param view the view
     * @param model the model
     * @exception NullPointerException if the view is null
     */
    protected void bindViewToModel(View view, Object model) throws NullPointerException {

        if (view != null) {

            if ((view instanceof PropertyView) /*??&& (((PropertyView) view).getSelector() != null)*/) {

                // views with selectors set are never bound by this controller: assumed to be handled by parent
                // ... that has delegated responsibility of a subsystem to this child. The high-level binding
                // ... is done by the parent.
                return;
            }

            view.setModel(model);

        } else {

            throw new NullPointerException("Could not bind view to model. The view is null.");
        }
    }

    //
    // View context.
    //

    /**
     * Returns the view context.
     *
     * @return the view context
     */
    public int getViewContext() {

        return this.viewContext;
    }

    /**
     * Sets the view context.
     *
     * @param viewContext the view context
     */
    public void setViewContext(int viewContext) {

        this.viewContext = viewContext;
    }

    /**
     * Creates a view context.
     *
     * The default is a swing view context.
     *
     * @return the view context
     */
    public int createViewContext() {

        return DisplayManager.SWING;
    }

    /*
     * Destroys the view context.
     */
    public void destroyViewContext() {
    }

    //
    // Configurable.
    //

    /**
     * Configures the system settings.
     *
     * @param c the system configuration
     * @exception NullPointerException if the system configuration is null
     */
    protected void configureSystemSettings(Configuration c) throws Exception {

        super.configureSystemSettings(c);

        if (c != null) {

            setViewContext(c.getViewContext(createViewContext()));

        } else {

            log(Level.WARNING, "Could not configure system settings. The system configuration is null.");
        }
    }

    /**
     * Deconfigures the system settings.
     *
     * @param c the system configuration
     * @exception NullPointerException if the system configuration is null
     */
    protected void deconfigureSystemSettings(Configuration c) throws Exception {

        try {

            if (c != null) {

                c.setViewContext(getViewContext());

            } else {

                throw new NullPointerException("Could not deconfigure system settings. The system configuration is null.");
            }

        } finally {

            super.deconfigureSystemSettings(c);
        }
    }

    /**
     * Configures the local settings.
     *
     * @param c the local configuration
     * @exception NullPointerException if the local configuration is null
     */
    protected void configureLocalSettings(Configuration c) throws Exception {

        super.configureLocalSettings(c);
    }

    /**
     * Deconfigures the local settings.
     *
     * @param c the local configuration
     * @exception NullPointerException if the local configuration is null
     */
    protected void deconfigureLocalSettings(Configuration c) throws Exception {

        super.deconfigureLocalSettings(c);
    }

    /**
     * Configures the user settings.
     *
     * @param c the user configuration
     * @exception NullPointerException if the user configuration is null
     */
    protected void configureUserSettings(Configuration c) throws Exception {

        super.configureUserSettings(c);

        if (c != null) {

            setViewContext(c.getViewContext(createViewContext()));

        } else {

            log(Level.WARNING, "Could not configure user settings. The user configuration is null.");
        }
    }

    /**
     * Deconfigures the user settings.
     *
     * @param c the user configuration
     * @exception NullPointerException if the user configuration is null
     */
    protected void deconfigureUserSettings(Configuration c) throws Exception {

        try {

            if (c != null) {

                c.setViewContext(getViewContext());

            } else {

                throw new NullPointerException("Could not deconfigure user settings. The user configuration is null.");
            }

        } finally {

            super.deconfigureUserSettings(c);
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this component.
     *
     * @exception NullPointerException if the view is null
     */
    public void initialize() throws Exception, NullPointerException {

        super.initialize();

        setView(createView());
        setModel(createModel());
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() throws Exception {

        try {

            destroyModel(getModel());
            setModel(null);

            destroyView((View) getView());
            setView(null);

        } finally {

            super.finalizz();
        }
    }

    //
    // Startable.
    //

    /**
     * Starts this component.
     *
     * @exception NullPointerException if ??
     */
    public void start() throws Exception {

        super.start();

        show(getView());
        load(getModel());
    }

    /**
     * Stops this component.
     *
     * @exception NullPointerException if ??
     */
    public void stop() throws Exception {

        try {

            save(getModel());
            hide(getView());

        } finally {

            super.stop();
        }
    }

    //
    // Suspendable.
    //

    /**
     * Suspends this component.
     *
     * @exception NullPointerException if ??
     */
    public void suspend() throws Exception {

        super.suspend();
    }

    /**
     * Resumes this component.
     *
     * @exception NullPointerException if ??
     */
    public void resume() throws Exception {

        super.resume();
    }

    /**
     * Recontextualizes this component.
     *
     * @exception NullPointerException if ??
     */
    public void recontextualize() throws Exception {

        super.recontextualize();
    }

    /**
     * Recomposes this component.
     *
     * @exception NullPointerException if ??
     */
    public void recompose() throws Exception {

        super.recompose();
    }

    /**
     * Reconfigures this component.
     *
     * @exception NullPointerException if ??
     */
    public void reconfigure() throws Exception {

        super.reconfigure();
    }

    //
    // Loggable.
    //

    /**
     * Logs a message with associated throwable information.
     *
     * Displays a graphical message dialog, in addition to the pure logging
     * being done in the parent class's log method.
     *
     * @param lev the level
     * @param msg the message
     * @param t the throwable
     */
    public void log(Level lev, String msg, Throwable t) throws Exception {

        super.log(lev, msg, t);

        DisplayManager dm = getDisplayManager();

        if (dm != null) {

//??            dm.showMessage(lev, msg, t);

            //?? Example for localization!
            //?? showError(e.getLocalizedSourceControlName(), e.getLocalizedMessage());

        } else {

            // Don't throw exception here cause not all controllers/applications
            // use a graphical display, i.e. not all have a display manager.
        }
    }

    //
    // Showable.
    //

    /**
     * Shows this component.
     *
     * @param v the view
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the display manager is null
     */
    public void show(View v) throws Exception, NullPointerException {

        View parent = null;
        Context c = getContext();

        if (c != null) {

            parent = (SwingView) c.getEntry("parent_view");

        } else {

            throw new NullPointerException("Could not determine parent view. The context is null.");
        }

        DisplayManager m = getDisplayManager();

        if (m != null) {

            log(Level.INFO, "Let the display manager show a display for the view.");
            m.createDisplay(v, parent);

        } else {

            throw new NullPointerException("Could not show view. The display manager is null.");
        }
    }

    /**
     * Hides this component.
     *
     * @param v the view
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the display manager is null
     */
    public void hide(View v) throws Exception, NullPointerException {

        View parent = null;
        Context c = getContext();

        if (c != null) {

            parent = (SwingView) c.getEntry("parent_view");

        } else {

            throw new NullPointerException("Could not determine parent view. The context is null.");
        }

        DisplayManager m = getDisplayManager();

        if (m != null) {

            log(Level.INFO, "Let the display manager hide the display of the view.");
            m.destroyDisplay(v, parent);

        } else {

            throw new NullPointerException("Could not hide view. The display manager is null.");
        }
    }

    //
    // Loadable.
    //

    /**
     * Loads this component's model.
     *
     * @param o the model
     * @exception NullPointerException if the persistence manager is null
     */
    public void load(Object o) throws Exception, NullPointerException {

        PersistenceManager m = getPersistenceManager();

/*??
        if (m != null) {

            // Let the persistence manager load the model.
            m.load(getModel());

        } else {

            throw new NullPointerException("Could not load model. The persistence manager is null.");
        }
*/
    }

    /**
     * Saves this component's model.
     *
     * @param o the model
     * @exception NullPointerException if the persistence manager is null
     */
    public void save(Object o) throws Exception, NullPointerException {

        PersistenceManager m = getPersistenceManager();

/*??
        if (m != null) {

            // Let the persistence manager save the model.
            m.save(getModel());

        } else {

            throw new NullPointerException("Could not save model. The persistence manager is null.");
        }
*/
    }

    //
    // Handle enabled.
    //

    /**
     * Handles the control (event).
     *
     * Do not override this method! Instead, use the <code>handle</code> method
     * to recognise controls that this controller can handle.
     * Any unhandled controls are passed up the chain of responsibility to parent controllers.
     *
     * Design patterns:
     * - Template method
     *
     * @param c the control
     * @exception NullPointerException if the control is null
     * @exception NullPointerException if the parent controller is null
     */
    public void handleControl(Control c) throws NullPointerException {

        if (c != null) {

            try {

/*??
                if (((Control) c).matches(Controller.CHANGE_MODEL_CONTROL_ID)) {

                    // Respond to CHANGE_MODEL_CONTROL_ID to keep the
                    // controller's model in sync with the currently shown model
                    // if it is changed as a submodel of a model managed by a
                    // parent controller.
                    setModel(c.getParameter());

                } else {

                    getDisplayManager().startProgress();
*/
                    handle(c);
/*??
                    getDisplayManager().stopProgress();
                }
*/

                // Handle unhandled controls.
                if (((Control) c).getMatched() == false) {

                    // Propogate from this.
//??                    c.setParameter(this);

                    BasicController parent = (BasicController) getParent();

                    if (parent != null) {

                        parent.handleControl(c);

                    } else {

                        throw new NullPointerException("Could not handle control event. The parent controller is null.");
                    }
                }

            } catch (Exception e) {

                System.out.println("Exception while handling control.");
                e.printStackTrace();
            }

        } else {

            throw new NullPointerException("Could not handle control event. The control is null.");
        }
    }

    /**
     * Handles the control (event).
     *
     * Override this method to recognise controls that this controller can handle.
     *
     * @param c the control
     */
    protected void handle(Control c) throws Exception {
    }

    //
    // Temporary event listeners. Will be deleted as soon as the framework
    // offers a different solution.
    //

    /**
     * ?? Temporary, until framework provides easier handling!
     *
     * Handles all action events of the whole application.
     *
     * @param evt the action event
     */
    public void actionPerformed(ActionEvent evt) {
    }

    /**
     * Listens and reacts to tree selection events.
     *
     * ?? Delete this method as soon as a ResTree component with event/control handling is provided!
     * ?? The direct call of Controller in this method is very unclean design!
     * ?? The Controller should only react to Control Events of the MVC framework!
     *
     * @param evt the tree selection event
     */
    public void valueChanged(TreeSelectionEvent evt) {
    }

    /**
     * Handles all item events of the whole application.
     *
     * @param e the item event
     */
    public void itemStateChanged(ItemEvent e)
    {
    }
    /**
     * Handles all keyPressed events of the whole application.
     *
     * @param evt the key pressed event
     */
    public void keyPressed(KeyEvent evt) {
    }

    /**
     * Handles all keyTyped events of the whole application.
     *
     * @param evt the key typed event
     */
    public void keyTyped(KeyEvent evt) {
    }

   /**
    * Handles all keyReleased events of the whole application.
    *
    * @param evt the key released event
    */
    public void keyReleased(KeyEvent evt) {
    }

    /**
     * Handles all mouseClicked events of the whole application.
     *
     * @param evt the mouse clicked event
     */
    public void mouseClicked(MouseEvent evt) {
    }

    /**
     * Not implemented
     */
    public void mouseEntered(MouseEvent evt) {
    }

   /**
     * Not implemented
     */
    public void mouseExited(MouseEvent evt) {
    }

    /**
    *Not implemented
    */
    public void mouseReleased(MouseEvent evt) {
    }

    /**
    *Not implemented
    */
    public void mousePressed(MouseEvent evt) {
    }

    /**
    *Not implemented
    */
    public void mouseDragged(MouseEvent evt) {
    }

    /**
     *Mouse moves are registered. If the mouse moved over a polygon area, the polygon is
     *drawn. The polygon info panel is also updated. If one polygon is already painted, and
     *the mouse is still on it, it will no be painted again (see isPainted()). If mouse moves
     *out of a polygon the whole panel is repainted and also overidden the painted polygons
     *Of course in this case the info panel is also updated.
     */
    public void mouseMoved(MouseEvent evt) {
    }

    /**
     * Here are all valueChanged events of the whole application handled. These
     * are events from tables, or lists.
     */
    public void valueChanged(ListSelectionEvent evt) {
    }

    /**
     * Here are all windowClosing events of the whole application handled.
     */
    public void windowClosing(WindowEvent evt) {
    }

	/**
	 * Evaluates the event if some attribute has changed
	 * @param evt DocumentEvent
	 */
	public void changedUpdate(DocumentEvent evt)
	{
	}
	/**
	 * Evaluates the event if something was inserted into the text area
	 * @param evt DocumentEvent
	 */
	public void insertUpdate(DocumentEvent evt)
	{
	}
	/**
	 * Evaluates the event if something was removed from the text area
	 * @param evt DocumentEvent
	 */
	public void removeUpdate(DocumentEvent evt)
	{
	}

    //
    // Focus listener.
    //

    /**
     * Invoked when a component gains the keyboard focus.
     */
    public void focusGained(FocusEvent evt) {
    }

    /**
     * Invoked when a component loses the keyboard focus.
     */
    public void focusLost(FocusEvent evt) {
    }

}

