/*
 * $RCSfile: AboutDialogView.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.about;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.net.*;
import javax.swing.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

/**
 * This class represents the view of the about dialog.
 *
 * It shows the following information about the system:
 * - name
 * - logo
 * - version
 * - license
 * - authors
 * - helpers
 *
 * @version $Revision: 1.3 $ $Date: 2002/08/08 15:43:17 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class AboutDialogView extends SwingView {

    //
    // Dialog bounds.
    //

    /**
     * Creates a rectangle storing the dialog bounds.
     *
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 640;

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = (screenWidth - w) / 2;

        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = (screenHeight - h) / 2;

        return new Rectangle(x, y, w, h);
    }

    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     *
     * @return the display mode
     */
    public int createDisplayMode() {

        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     *
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {

        Control c = new Control();
        
        if (c != null) {
        
            c.setId(AboutDialog.DESTROY_ABOUT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
            
        } else {
            
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        
        return c;
    }

    //
    // Head panel.
    //

    /**
     * Creates the head panel.
     *
     * @return the head panel
     * @exception NullPointerException if the head panel is null
     */
    private ResPanel createHeadPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            p.setLayout(new BorderLayout());
            p.add(createNameLabel(), BorderLayout.WEST);
            p.add(createVersionLabel(), BorderLayout.CENTER);
            p.add(createDateLabel(), BorderLayout.EAST);
            p.add(createSloganLabel(), BorderLayout.SOUTH);

        } else {

            throw new NullPointerException("Could not create head panel. The head panel is null.");
        }

        return p;
    }

    /**
     * Creates the name label.
     *
     * @return the name label
     * @exception NullPointerException if the name label is null
     */
    private ResLabel createNameLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("name");
            l.setFont(new Font(null, Font.BOLD, 18));

        } else {

            throw new NullPointerException("Could not create name label. The name label is null.");
        }

        return l;
    }

    /**
     * Creates the version label.
     *
     * @return the version label
     * @exception NullPointerException if the version label is null
     */
    private ResLabel createVersionLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("version");
            l.setFont(new Font(null, Font.BOLD, 18));
            l.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));

        } else {

            throw new NullPointerException("Could not create version label. The version label is null.");
        }

        return l;
    }

    /**
     * Creates the date label.
     *
     * @return the date label
     * @exception NullPointerException if the date label is null
     */
    private ResLabel createDateLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("date");
            l.setHorizontalAlignment(ResLabel.RIGHT);

        } else {

            throw new NullPointerException("Could not create date label. The date label is null.");
        }

        return l;
    }

    /**
     * Creates the slogan label.
     *
     * @return the slogan label
     * @exception NullPointerException if the slogan label is null
     */
    private ResLabel createSloganLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("slogan");

        } else {

            throw new NullPointerException("Could not create slogan label. The slogan label is null.");
        }

        return l;
    }

    //
    // Tabbed pane.
    //

    /**
     * Creates the tabbed pane.
     *
     * @return the tabbed pane
     * @exception NullPointerException if the tabbed pane is null
     */
    private ResTabbedPane createTabbedPane() throws NullPointerException {

        ResTabbedPane tp = new ResTabbedPane();

        if (tp != null) {

            // Initialize tabbed pane.
            tp.addTab("Splash", createSplashPanel());
            tp.addTab("Copyright", createCopyrightPanel());
            tp.addTab("Authors", new ResScrollPane(createAuthorsPanel()));
            tp.addTab("Helpers", new ResScrollPane(createHelpersPanel()));
            tp.addTab("Inspirations", new ResScrollPane(createInspirationsPanel()));
            tp.addTab("License", new ResScrollPane(createLicensePanel()));

        } else {

            throw new NullPointerException("Could not create tabbed pane. The tabbed pane is null.");
        }

        return tp;
    }

    /**
     * Creates the splash panel.
     *
     * @return the splash panel
     * @exception NullPointerException if the splash panel is null
     */
    private ResPanel createSplashPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createSplashLabel(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create splash panel. The splash panel is null.");
        }

        return p;
    }

    /**
     * Creates the splash label.
     *
     * @return the splash label
     * @exception NullPointerException if the splash label is null
     */
    private ResLabel createSplashLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

            String file = "logo.jpeg";
            URL location = getClass().getResource(file);

            l.setIcon(new ResImageIcon(location));
            l.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        } else {

            throw new NullPointerException("Could not create splash label. The splash label is null.");
        }

        return l;
    }

    /**
     * Creates the copyright panel.
     *
     * @return the copyright panel
     * @exception NullPointerException if the copyright panel is null
     */
    private ResPanel createCopyrightPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createCopyrightLabel(), BorderLayout.NORTH);
            p.add(createContactLabel(), BorderLayout.NORTH);
            p.add(new ResScrollPane(createDescriptionTextPane()), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create copyright panel. The copyright panel is null.");
        }

        return p;
    }

    /**
     * Creates the copyright label.
     *
     * @return the copyright label
     * @exception NullPointerException if the copyright label is null
     */
    private ResLabel createCopyrightLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("copyright");
            l.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        } else {

            throw new NullPointerException("Could not create copyright label. The copyright label is null.");
        }

        return l;
    }

    /**
     * Creates the contact label.
     *
     * @return the contact label
     * @exception NullPointerException if the contact label is null
     */
    private ResLabel createContactLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("contact");
            l.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        } else {

            throw new NullPointerException("Could not create contact label. The contact label is null.");
        }

        return l;
    }

    /**
     * Creates the description text pane.
     *
     * @return the description text pane
     * @exception NullPointerException if the description text pane is null
     */
    private ResTextPane createDescriptionTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("description");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create description text pane. The description text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the authors panel.
     *
     * @return the authors panel
     * @exception NullPointerException if the authors panel is null
     */
    private ResPanel createAuthorsPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createAuthorsTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create authors panel. The authors panel is null.");
        }

        return p;
    }

    /**
     * Creates the authors text pane.
     *
     * @return the authors text pane
     * @exception NullPointerException if the authors text pane is null
     */
    private ResTextPane createAuthorsTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("authors");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create authors text pane. The authors text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the helpers panel.
     *
     * @return the helpers panel
     * @exception NullPointerException if the helpers panel is null
     */
    private ResPanel createHelpersPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createHelpersTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create helpers panel. The helpers panel is null.");
        }

        return p;
    }

    /**
     * Creates the helpers text pane.
     *
     * @return the helpers text pane
     * @exception NullPointerException if the helpers text pane is null
     */
    private ResTextPane createHelpersTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("helpers");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create helpers text pane. The helpers text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the inspirations panel.
     *
     * @return the inspirations panel
     * @exception NullPointerException if the inspirations panel is null
     */
    private ResPanel createInspirationsPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createInspirationsTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create inspirations panel. The inspirations panel is null.");
        }

        return p;
    }

    /**
     * Creates the inspirations text pane.
     *
     * @return the inspirations text pane
     * @exception NullPointerException if the inspirations text pane is null
     */
    private ResTextPane createInspirationsTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("inspirations");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create inspirations text pane. The inspirations text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the license panel.
     *
     * @return the license panel
     * @exception NullPointerException if the license panel is null
     */
    private ResPanel createLicensePanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createLicenseTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create license panel. The license panel is null.");
        }

        return p;
    }

    /**
     * Creates the license text pane.
     *
     * @return the license text pane
     * @exception NullPointerException if the license text pane is null
     */
    private ResTextPane createLicenseTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("license");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create license text pane. The license text pane is null.");
        }

        return tp;
    }

    //
    // Button panel.
    //

    /**
     * Creates the button panel.
     *
     * @return the button panel
     * @exception NullPointerException if the button panel is null
     */
    private ResPanel createButtonPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            p.setLayout(new BorderLayout());
            p.add(createCloseButton(), BorderLayout.EAST);

        } else {

            throw new NullPointerException("Could not create button panel. The button panel is null.");
        }

        return p;
    }

    /**
     * Creates the close button.
     *
     * @return the close button
     * @exception NullPointerException if the close button is null
     */
    private ResButton createCloseButton() throws NullPointerException {

        ResButton b = new ResButton();

        if (b != null) {

            b.setText("Close");
            b.setMnemonic(KeyEvent.VK_C);
            b.setControlId(Controller.DESTROY_CONTROLLER_CONTROL_ID);
//??            b.setOwner(this);

        } else {

            throw new NullPointerException("Could not create close button. The close button is null.");
        }

        return b;
    }

    //
    // Initializable.
    //

    /**
     * Initializes this component.
     */
    public void initialize() throws Exception {

        super.initialize();

        // Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        // Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
        setDialogBounds(createDialogBounds());

        // Set parameters.
        setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        // Add panels.
        add(createHeadPanel(), BorderLayout.NORTH);
        add(createTabbedPane(), BorderLayout.CENTER);
        add(createButtonPanel(), BorderLayout.SOUTH);
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() throws Exception {

        try {

            // Set parameters.
            setBorder(null);

        } finally {

            super.finalizz();
        }
    }
}

