/*
 * $RCSfile: AboutDialogModel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.about;

import java.lang.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.model.*;

/**
 * This class represents an about dialog model.
 *
 * It contains application specific information.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:34 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class AboutDialogModel extends Model {

    //
    // Attributes.
    //

    /** The name. */
    private String name;

    /** The version. */
    private String version;

    /** The date. */
    private String date;

    /** The slogan. */
    private String slogan;

    /** The logo. */
    private String logo;

    /** The copyright. */
    private String copyright;

    /** The contact. */
    private String contact;

    /** The description. */
    private String description;

    /** The authors. */
    private String authors;

    /** The helpers. */
    private String helpers;

    /** The inspirations. */
    private String inspirations;

    /** The license. */
    private String license;

    //
    // Name.
    //

    /**
     * Returns the name.
     *
     * @return the name
     */
    public String getName() {

        return this.name;
    }

    /**
     * Sets the name.
     *
     * @param name the name
     */
    public void setName(String name) {

        this.name = name;
    }

    //
    // Version.
    //

    /**
     * Returns the version.
     *
     * (major).(minor).(<99 = preX, 99 = final).(bug fix)
     *
     * @return the version
     */
    public String getVersion() {

        return this.version;
    }

    /**
     * Sets the version.
     *
     * @param version the version
     */
    public void setVersion(String version) {

        this.version = version;
    }

    //
    // Date.
    //

    /**
     * Returns the release date.
     *
     * @return the release date
     */
    public String getDate() {

        return this.date;
    }

    /**
     * Sets the release date.
     *
     * @param date the release date
     */
    public void setDate(String date) {

        this.date = date;
    }

    //
    // Slogan.
    //

    /**
     * Returns the slogan.
     *
     * @return the slogan
     */
    public String getSlogan() {

        return this.slogan;
    }

    /**
     * Sets the slogan.
     *
     * @param slogan the slogan
     */
    public void setSlogan(String slogan) {

        this.slogan = slogan;
    }

    //
    // Logo.
    //

    /**
     * Returns the logo.
     *
     * @return the logo
     */
    public String getLogo() {

        return this.logo;
    }

    /**
     * Sets the logo.
     *
     * @param logo the logo
     */
    public void setLogo(String logo) {

        this.logo = logo;
    }

    //
    // Copyright.
    //

    /**
     * Returns the copyright.
     *
     * @return the copyright
     */
    public String getCopyright() {

        return this.copyright;
    }

    /**
     * Sets the copyright.
     *
     * @param copyright the copyright
     */
    public void setCopyright(String copyright) {

        this.copyright = copyright;
    }

    //
    // Contact.
    //

    /**
     * Returns the contact.
     *
     * @return the contact
     */
    public String getContact() {

        return this.contact;
    }

    /**
     * Sets the contact.
     *
     * @param contact the contact
     */
    public void setContact(String contact) {

        this.contact = contact;
    }

    //
    // Description.
    //

    /**
     * Returns the description.
     *
     * @return the description
     */
    public String getDescription() {

        return this.description;
    }

    /**
     * Sets the description.
     *
     * @param description the description
     */
    public void setDescription(String description) {

        this.description = description;
    }

    //
    // Authors.
    //

    /**
     * Returns the authors.
     *
     * @return the authors
     */
    public String getAuthors() {

        return this.authors;
    }

    /**
     * Sets the authors.
     *
     * @param authors the authors
     */
    public void setAuthors(String authors) {

        this.authors = authors;
    }

    //
    // Helpers.
    //

    /**
     * Returns the helpers.
     *
     * @return the helpers
     */
    public String getHelpers() {

        return this.helpers;
    }

    /**
     * Sets the helpers.
     *
     * @param helpers the helpers
     */
    public void setHelpers(String helpers) {

        this.helpers = helpers;
    }

    //
    // Inspirations.
    //

    /**
     * Returns the inspirations.
     *
     * @return the inspirations
     */
    public String getInspirations() {

        return this.inspirations;
    }

    /**
     * Sets the inspirations.
     *
     * @param inspirations the inspirations
     */
    public void setInspirations(String inspirations) {

        this.inspirations = inspirations;
    }

    //
    // License.
    //

    /**
     * Returns the license.
     *
     * @return the license
     */
    public String getLicense() {

        return this.license;
    }

    /**
     * Sets the license.
     *
     * @param license the license
     */
    public void setLicense(String license) {

        this.license = license;
    }

    //
    // Contextualizable.
    //

    /**
     * Contextualizes this component.
     *
     * @param c the context
     */
    public void contextualize(Context c) throws Exception {

        super.contextualize(c);

        if (c != null) {

            setName((String) c.getEntry("name"));
            setVersion((String) c.getEntry("version"));
            setDate((String) c.getEntry("date"));
            setSlogan((String) c.getEntry("slogan"));
            setLogo((String) c.getEntry("logo"));
            setCopyright((String) c.getEntry("copyright"));
            setContact((String) c.getEntry("contact"));
            setDescription((String) c.getEntry("description"));
            setAuthors((String) c.getEntry("authors"));
            setHelpers((String) c.getEntry("helpers"));
            setInspirations((String) c.getEntry("inspirations"));
            setLicense((String) c.getEntry("license"));

        } else {

            throw new NullPointerException("Could not contextualize component. The context is null.");
        }
    }

    /**
     * Decontextualizes this component.
     *
     * @param c the context
     */
    public void decontextualize(Context c) throws Exception {

        try {

            setName(null);
            setVersion(null);
            setDate(null);
            setSlogan(null);
            setLogo(null);
            setCopyright(null);
            setContact(null);
            setDescription(null);
            setAuthors(null);
            setHelpers(null);
            setInspirations(null);
            setLicense(null);

        } finally {

            super.decontextualize(c);
        }
    }
}

