/*
 * $RCSfile: AboutDialog.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.about;

import java.lang.*;
import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.model.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents an about dialog controller.
 *
 * It shows information about an application.
 *
 * @version $Revision: 1.4 $ $Date: 2002/08/08 15:43:17 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class AboutDialog extends BasicController {

    //
    // Control id constants.
    //

    /** The create about dialog control id. */
    public static final String CREATE_ABOUT_DIALOG_CONTROL_ID = "create_about_dialog";
    
    /** The destroy about dialog control id. */
    public static final String DESTROY_ABOUT_DIALOG_CONTROL_ID = "destroy_about_dialog";

    //
    // View.
    //

    /**
     * Creates a view.
     *
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws Exception, NullPointerException {

        AboutDialogView v = new AboutDialogView();

        if (v != null) {

            ((AboutDialogView) v).configure(getConfigurationManager());
            ((AboutDialogView) v).initialize();
            
        } else {
            
            throw new NullPointerException("Could not create view. The view is null."); 
        }

        return v;
    }

    //
    // Model.
    //

    /**
     * Creates a model.
     *
     * @return the model
     * @exception NullPointerException if the model is null
     */
    public Object createModel() throws Exception, NullPointerException {

        AboutDialogModel m = new AboutDialogModel();
        
        if (m != null) {

            ((AboutDialogModel) m).contextualize(getContext());            
            
        } else {
            
            throw new NullPointerException("Could not create model. The model is null."); 
        }
        
        return m;
    }
}

