/*
 * $RCSfile: MainApplicationModel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.common.main;

import java.lang.*;
import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.model.*;

/**
 * This class represents the main application model.
 *
 * It keeps all data to be displayed, especially a tree of available applications.
 *
 * @version $Revision: 1.3 $ $Date: 2002/06/12 23:55:06 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class MainApplicationModel extends Model {

    //
    // Attributes.
    //

    /** The available applications tree. */
    private ApplicationTreeNode availableApplications;

    //
    // Available applications.
    //

    /**
     * Returns the available applications tree.
     *
     * @return the available applications tree
     */
    public ApplicationTreeNode getAvailableApplications() {

        return this.availableApplications;
    }

    /**
     * Sets the available applications tree.
     *
     * @param availableApplications the available applications tree
     */
    public void setAvailableApplications(ApplicationTreeNode availableApplications) {

        this.availableApplications = availableApplications;
    }

    /**
     * Creates an available applications tree.
     *
     * @return the available applications tree
     */
    public ApplicationTreeNode createAvailableApplications() {

        ApplicationTreeNode t = null;
        TreeBuilder b = new TreeBuilder();
        String[] s = new String[20];

        if (s != null) {

            s[0] = "/main/ResMedicinae,false,org.resmedicinae.application.common.main.MainApplication";
            s[1] = "/healthcare/Record,false,org.resmedicinae.application.healthcare.record.Record";
            s[2] = "/healthcare/ReForm,false,org.resmedicinae.application.healthcare.reform.ReForm";
            s[3] = "/healthcare/ReVision,false,org.resmedicinae.application.healthcare.revision.ReVision";
            s[4] = "/healthcare/ResAddress,false,org.resmedicinae.application.healthcare.resaddress.ResAddress";
            s[5] = "/healthcare/ResLab,false,org.resmedicinae.application.healthcare.reslab.ResLab";
            s[6] = "/healthcare/Restore,false,org.resmedicinae.application.healthcare.restore.Restore";
            s[7] = "/sample/Simple,false,org.resmedicinae.application.sample.simple.Simple";
            s[8] = "/sample/HelloWorld,false,org.resmedicinae.application.sample.helloworld.HelloWorld";
            s[9] = "/external/kedit,true,kedit";
            s[10] = "/external/konsole,true,konsole";
            s[11] = "/external/kmail,true,kmail";
            s[12] = "/external/notepad,true,notepad.exe";
            s[13] = "/external/cmd,true,cmd.exe";

        } else {

            throw new NullPointerException("Could not create available applications tree. The string array is null.");
        }

        if (b != null) {

            t = b.build(s);

        } else {

            throw new NullPointerException("Could not create available applications tree. The tree builder is null.");
        }

        return t;
    }

    /**
     * Destroys the available applications.
     *
     * @param m the available applications tree
     * @exception NullPointerException if the available applications tree is null
     */
    public void destroyAvailableApplications(ApplicationTreeNode t) throws NullPointerException {

        if (t != null) {

        } else {

            throw new NullPointerException("Could not destroy available applications tree. The available applications tree is null.");
        }
    }

    //
    // Configurable.
    //

    /**
     * Configures the system settings.
     *
     * @param c the configuration
     * @exception NullPointerException if the configuration is null
     */
    protected void configureSystemSettings(Configuration c) throws Exception, NullPointerException {

        super.configureSystemSettings(c);

        if (c != null) {

/*??
            Preferences p = c.get("available_applications", null);
            ApplicationTreeNode t = new ApplicationTreeNode();
            
            if (t != null) {
                
            String[] children = c.childrenNames();
*/

            TreeBuilder b = new TreeBuilder();

            if (b != null) {

//??                ApplicationTreeNode t = b.build(((ResMedicinaeConfiguration) c).getAvailableApplications());
                ApplicationTreeNode t = createAvailableApplications();

                setAvailableApplications(t);

            } else {

                throw new NullPointerException("Could not create available applications tree. The tree builder is null.");
            }

        } else {

            throw new NullPointerException("Could not configure system settings. The configuration is null.");
        }
    }

    /**
     * Deconfigures the system settings.
     *
     * @param c the configuration
     * @exception NullPointerException if the configuration is null
     */
    protected void deconfigureSystemSettings(Configuration c) throws Exception, NullPointerException {

        try {

            if (c != null) {

/*??
                ApplicationTreeNode t = getAvailableApplications();
                
                if (t != null) {
                    
                    t.deconfigureSystemSettings(c);

                } else {
    
                    throw new NullPointerException("Could not deconfigure system settings. The available applications tree node is null.");
                }
*/

            } else {

                throw new NullPointerException("Could not deconfigure system settings. The configuration is null.");
            }

        } finally {

            super.deconfigureSystemSettings(c);
        }
    }
}


