/*
 * $RCSfile: MainApplicationMenuBar.java,v $
 *
 * Copyright (c) 1999-2001. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.common.main;

// Caution: Don't add java.awt.* here!
// The awt contains equally named classes that would conflict with this one.
import java.awt.event.*;
import java.lang.*;
import org.resmedicinae.application.controller.about.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

/**
 * This class represents a menu bar.
 *
 * @version $Revision: 1.4 $ $Date: 2002/08/09 21:12:40 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class MainApplicationMenuBar extends ResMenuBar {
    
    //
    // Menus.
    //

    /** The application menu. */
    private ResMenu applicationMenu;
    /** The editor menu. */
    private ResMenu editorMenu;
    /** The view menu. */
    private ResMenu viewMenu;
    /** The context menu. */
    private ResMenu contextMenu;
    /** The settings menu. */
    private ResMenu settingsMenu;
    /** The window menu. */
    private ResMenu windowMenu;
    /** The placing menu. */
    private ResMenu placingMenu;
    /** The mode menu. */
    private ResMenu modeMenu;
    /** The help menu. */
    private ResMenu helpMenu;

    //
    // Menu items.
    //

    /** The exit menu item. */
    private ResMenuItem exitMenuItem;
    /** The cut menu item. */
    private ResMenuItem cutMenuItem;
    /** The copy menu item. */
    private ResMenuItem copyMenuItem;
    /** The paste menu item. */
    private ResMenuItem pasteMenuItem;
    /** The show tool bar menu item. */
    private ResCheckBoxMenuItem showToolBarMenuItem;
    /** The show status bar menu item. */
    private ResCheckBoxMenuItem showStatusBarMenuItem;
    /** The show application tree menu item. */
    private ResCheckBoxMenuItem showApplicationTreeMenuItem;
    /** The configure menu bar menu item. */
    private ResMenuItem configureMenuBarMenuItem;
    /** The configure tool bars menu item. */
    private ResMenuItem configureToolBarMenuItem;
    /** The configure status bar menu item. */
    private ResMenuItem configureStatusBarMenuItem;
    /** The configure key bindings menu item. */
    private ResMenuItem configureKeyBindingsMenuItem;
    /** The configure application tree menu item. */
    private ResMenuItem configureApplicationTreeMenuItem;
    /** The configure Res Medicinae menu item. */
    private ResMenuItem configureResMedicinaeMenuItem;
    /** The iconify all menu item. */
    private ResMenuItem iconifyAllMenuItem;
    /** The close menu item. */
    private ResMenuItem closeMenuItem;
    /** The close all menu item. */
    private ResMenuItem closeAllMenuItem;
    /** The cascade menu item. */
    private ResMenuItem cascadeMenuItem;
    /** The tile vertically menu item. */
    private ResMenuItem tileVerticallyMenuItem;
    /** The tile horizontally menu item. */
    private ResMenuItem tileHorizontallyMenuItem;
    /** The set frame display menu item. */
    private ResRadioButtonMenuItem setFrameDisplayMenuItem;
    /** The set internal frame display menu item. */
    private ResRadioButtonMenuItem setInternalFrameDisplayMenuItem;
    /** The set tab page display menu item. */
    private ResRadioButtonMenuItem setTabPageDisplayMenuItem;
    /** The show contents menu item. */
    private ResMenuItem showContentsMenuItem;
    /** The report bug menu item. */
    private ResMenuItem reportBugMenuItem;
    /** The link to website menu item. */
    private ResMenuItem linkToWebsiteMenuItem;
    /** The inform about Res Medicinae menu item. */
    private ResMenuItem informAboutResMedicinaeMenuItem;

    //
    // Temporary test.
    //
    
    /** The owning view. */
    private MainApplicationView owner;

    //
    // Application menu.
    //
    
    /**
     * Returns the application menu.
     *
     * @return the application menu
     */
    public ResMenu getApplicationMenu() {

        return this.applicationMenu;
    }
    
    /**
     * Sets the application menu.
     *
     * @param applicationMenu the application menu
     */
    public void setApplicationMenu(ResMenu applicationMenu) {

        this.applicationMenu = applicationMenu;        
    }

    /**
     * Returns the exit menu item.
     *
     * @return the exit menu item
     */
/*??
    public ResMenuItem getExitMenuItem() {

        return this.exitMenuItem;
    }

    /**
     * Returns the configure application tree menu item.
     *
     * @return the configure application tree menu item
     */
/*??
    public ResMenuItem getConfigureApplicationTreeMenuItem() {

        return this.configureApplicationTreeMenuItem;
    }

    /**
     * Returns the configure Res Medicinae menu item.
     *
     * @return the configure Res Medicinae menu item
     */
/*??
    public ResMenuItem getConfigureResMedicinaeMenuItem() {

        return this.configureResMedicinaeMenuItem;
    }

    /**
     * Returns the set frames menu item.
     *
     * @return the set frames menu item
     */
/*??
    public ResRadioButtonMenuItem getSetFramesMenuItem() {

        return this.setFramesMenuItem;
    }

    /**
     * Returns the set internal frames menu item.
     *
     * @return the set internal frames menu item
     */
/*??
    public ResRadioButtonMenuItem getSetInternalFramesMenuItem() {

        return this.setInternalFramesMenuItem;
    }

    /**
     * Returns the set tabbed frame menu item.
     *
     * @return the set tabbed frame menu item
     */
/*??
    public ResRadioButtonMenuItem getSetTabbedPaneMenuItem() {

        return this.setTabbedPaneMenuItem;
    }

    /**
     * Returns the inform about Res Medicinae menu item.
     *
     * @return the inform about Res Medicinae menu item
     */
/*??
    public ResMenuItem getInformAboutResMedicinaeMenuItem() {

        return this.informAboutResMedicinaeMenuItem;
    }

    //
    // Owning view.
    //
    
    /**
     * Returns the owning view.
     *
     * @return the owning view
     */
    public MainApplicationView getOwner() {

        return this.owner;
    }
    
    /**
     * Sets the owning view.
     *
     * @param owner the owning view
     */
    public void setOwner(MainApplicationView owner) {

        this.owner = owner;        
    }

    //
    // Application menu.
    //
    
    /**
     * Creates application menu.
     *
     * It is based on the available application tree of the view's controller.
     * The applications will be displayed as a menu hierarchy
     * using the ApplicationMenu class.
     *
     * @return the application menu
     * @exception NullPointerException if the application menu is null
     */
    private ResMenu createApplicationMenu() throws Exception, NullPointerException {

        ResMenu m = new ResMenu();
        
        if (m != null) {

            // Initialize menu and add menu items.
            m.setText("Applications");
            m.setMnemonic(KeyEvent.VK_A);
            m.add(createApplicationsMenu());
            m.addSeparator();
            m.add(createExitMenuItem());

        } else {

            throw new NullPointerException("Could not create application menu. The application menu is null.");
        }

        return m;
    }

    /**
     * Creates an applications menu.
     *
     * @return the applications menu
     * @exception NullPointerException if the applications menu is null
     */
    public ApplicationMenu createApplicationsMenu() throws NullPointerException {
        
        ApplicationTreeNode n = null;
        ApplicationMenu m = new ApplicationMenu();

        if (m != null) {

/*??
            m.setApplications(n);
            m.setControlId(MainApplication.CREATE_APPLICATION_CONTROL_ID);

            m.setText("Main");
            m.setText("Healthcare");
            m.setMnemonic(KeyEvent.VK_E);
            m.setControlId(MainApplication.DESTROY_APPLICATION_CONTROL_ID);
            //?? Clear this line up. Don't use getController() on view!
            System.out.println("test: " + (Object) v.getController());
            m.setControlParameter((Object) v.getController());
            m.setOwner(getOwner());
            m.setEnabled(true);
*/

        } else {

            throw new NullPointerException("Could not create exit menu item. The application menu is null.");
        }
        
        return m;
    }

    /**
     * Creates an exit menu item.
     *
     * @return the exit menu item
     * @exception NullPointerException if the exit menu item is null
     */
    public ResMenuItem createExitMenuItem() throws NullPointerException {
        
        ResMenuItem m = new ResMenuItem();

        if (m != null) {

            m.setText("Exit");
            m.setMnemonic(KeyEvent.VK_E);
            m.setControlId(MainApplication.DESTROY_APPLICATION_CONTROL_ID);
            m.setControlParameter(getOwner().getController());
            m.setOwner(getOwner());
            m.setEnabled(true);

        } else {

            throw new NullPointerException("Could not create exit menu item. The exit menu item is null.");
        }
        
        return m;
    }

    //
    // Editor menu.
    //
    
    /**
     * Creates editor menu.
     *
     * @param v the view owning this menu bar
     * @return the editor menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createEditorMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
        ResMenuItem cutMenuItem = new ResMenuItem();
        ResMenuItem copyMenuItem = new ResMenuItem();
        ResMenuItem pasteMenuItem = new ResMenuItem();

        // Initialize menu items.
        if (cutMenuItem != null) {

            cutMenuItem.setText("Cut");
            cutMenuItem.setMnemonic(KeyEvent.VK_U);
            cutMenuItem.setControlId(MainApplication.CUT_CONTROL_ID);
            cutMenuItem.setOwner(getOwner());
            cutMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create editor menu. The cut menu item is null.");
        }

        if (copyMenuItem != null) {

            copyMenuItem.setText("Copy");
            copyMenuItem.setMnemonic(KeyEvent.VK_C);
            copyMenuItem.setControlId(MainApplication.COPY_CONTROL_ID);
            copyMenuItem.setOwner(getOwner());
            copyMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create editor menu. The copy menu item is null.");
        }

        if (pasteMenuItem != null) {

            pasteMenuItem.setText("Paste");
            pasteMenuItem.setMnemonic(KeyEvent.VK_P);
            pasteMenuItem.setControlId(MainApplication.PASTE_CONTROL_ID);
            pasteMenuItem.setOwner(getOwner());
            pasteMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create editor menu. The paste menu item is null.");
        }

        if (m != null) {

            // Initialize menu and add menu items.
            m.setText("Editor");
            m.setMnemonic(KeyEvent.VK_E);
            m.add(cutMenuItem);
            m.add(copyMenuItem);
            m.add(pasteMenuItem);

        } else {

            throw new NullPointerException("Could not create editor menu. The editor menu is null.");
        }

        return m;
    }

    //
    // View menu.
    //
    
    /**
     * Creates view menu.
     *
     * @param v the view owning this menu bar
     * @return the view menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createViewMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
        ResCheckBoxMenuItem showToolBarMenuItem = new ResCheckBoxMenuItem();
        ResCheckBoxMenuItem showStatusBarMenuItem = new ResCheckBoxMenuItem();
        ResCheckBoxMenuItem showApplicationTreeMenuItem = new ResCheckBoxMenuItem();

        // Initialize menu items.
        if (showToolBarMenuItem != null) {

            showToolBarMenuItem.setText("Show Tool Bar");
            showToolBarMenuItem.setMnemonic(KeyEvent.VK_T);
            showToolBarMenuItem.setControlId(MainApplication.SHOW_TOOL_BAR_CONTROL_ID);
            showToolBarMenuItem.setOwner(getOwner());
            showToolBarMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create view menu. The show tool bar menu item is null.");
        }

        if (showStatusBarMenuItem != null) {

            showStatusBarMenuItem.setText("Show Status Bar");
            showStatusBarMenuItem.setMnemonic(KeyEvent.VK_S);
            showStatusBarMenuItem.setControlId(MainApplication.SHOW_STATUS_BAR_CONTROL_ID);
            showStatusBarMenuItem.setOwner(getOwner());
            showStatusBarMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create view menu. The show status bar menu item is null.");
        }

        if (showApplicationTreeMenuItem != null) {

            showApplicationTreeMenuItem.setText("Show Application Tree");
            showApplicationTreeMenuItem.setMnemonic(KeyEvent.VK_M);
            showApplicationTreeMenuItem.setControlId(MainApplication.SHOW_APPLICATION_TREE_CONTROL_ID);
            showApplicationTreeMenuItem.setOwner(getOwner());
            showApplicationTreeMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create view menu. The show application tree menu item is null.");
        }

        if (m != null) {

            // Initialize menu and add menu items.
            m.setText("View");
            m.setMnemonic(KeyEvent.VK_V);
            m.add(showToolBarMenuItem);
            m.add(showStatusBarMenuItem);
            m.add(showApplicationTreeMenuItem);

        } else {

            throw new NullPointerException("Could not create view menu. The view menu is null.");
        }

        return m;
    }

    //
    // Context menu.
    //
    
    /**
     * Creates context menu.
     *
     * @param v the view owning this menu bar
     * @return the context menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createContextMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();

        // Initialize menu items.

        if (m != null) {

            // Initialize menu and add menu items.
            m.setText("Context");
            m.setMnemonic(KeyEvent.VK_C);
            m.addSeparator();

        } else {

            throw new NullPointerException("Could not create context menu. The context menu is null.");
        }

        return m;
    }

    //
    // Settings menu.
    //
    
    /**
     * Creates settings menu.
     *
     * @param v the view owning this menu bar
     * @return the settings menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createSettingsMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
        ResMenuItem configureMenuBarMenuItem = new ResMenuItem();
        ResMenuItem configureToolBarMenuItem = new ResMenuItem();
        ResMenuItem configureStatusBarMenuItem = new ResMenuItem();
        ResMenuItem configureKeyBindingsMenuItem = new ResMenuItem();
        ResMenuItem configureApplicationTreeMenuItem = new ResMenuItem();
        ResMenuItem configureResMedicinaeMenuItem = new ResMenuItem();

        // Initialize menu items.
        if (configureMenuBarMenuItem != null) {

            configureMenuBarMenuItem.setText("Configure Menu Bar...");
            configureMenuBarMenuItem.setMnemonic(KeyEvent.VK_E);
            configureMenuBarMenuItem.setControlId(MainApplication.CONFIGURE_MENU_BAR_CONTROL_ID);
            configureMenuBarMenuItem.setOwner(getOwner());
            configureMenuBarMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create settings menu. The configure menu bar menu item is null.");
        }

        if (configureToolBarMenuItem != null) {

            configureToolBarMenuItem.setText("Configure Tool Bars...");
            configureToolBarMenuItem.setMnemonic(KeyEvent.VK_T);
            configureToolBarMenuItem.setControlId(MainApplication.CONFIGURE_TOOL_BAR_CONTROL_ID);
            configureToolBarMenuItem.setOwner(getOwner());
            configureToolBarMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create settings menu. The configure tool bar menu item is null.");
        }

        if (configureStatusBarMenuItem != null) {

            configureStatusBarMenuItem.setText("Configure Status Bar...");
            configureStatusBarMenuItem.setMnemonic(KeyEvent.VK_U);
            configureStatusBarMenuItem.setControlId(MainApplication.CONFIGURE_STATUS_BAR_CONTROL_ID);
            configureStatusBarMenuItem.setOwner(getOwner());
            configureStatusBarMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create settings menu. The configure status bar menu item is null.");
        }

        if (configureKeyBindingsMenuItem != null) {

            configureKeyBindingsMenuItem.setText("Configure Key Bindings...");
            configureKeyBindingsMenuItem.setMnemonic(KeyEvent.VK_K);
            configureKeyBindingsMenuItem.setControlId(MainApplication.CONFIGURE_KEY_BINDINGS_CONTROL_ID);
            configureKeyBindingsMenuItem.setOwner(getOwner());
            configureKeyBindingsMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create settings menu. The configure key bindings menu item is null.");
        }

        if (configureApplicationTreeMenuItem != null) {

            configureApplicationTreeMenuItem.setText("Configure Application Tree...");
            configureApplicationTreeMenuItem.setMnemonic(KeyEvent.VK_C);
            configureApplicationTreeMenuItem.setControlId(MainApplication.CONFIGURE_APPLICATION_TREE_CONTROL_ID);
            configureApplicationTreeMenuItem.setOwner(getOwner());
            configureApplicationTreeMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create settings menu. The configure application tree menu item is null.");
        }

        if (configureResMedicinaeMenuItem != null) {

            configureResMedicinaeMenuItem.setText("Configure Res Medicinae...");
            configureResMedicinaeMenuItem.setMnemonic(KeyEvent.VK_S);
            configureResMedicinaeMenuItem.setControlId(MainApplication.CONFIGURE_RES_MEDICINAE_CONTROL_ID);
            configureResMedicinaeMenuItem.setOwner(getOwner());
            configureResMedicinaeMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create settings menu. The configure res medicinae menu item is null.");
        }

        if (m != null) {

            // Initialize settings menu and add menu items.
            m.setText("Settings");
            m.setMnemonic(KeyEvent.VK_S);
            m.add(configureMenuBarMenuItem);
            m.add(configureToolBarMenuItem);
            m.add(configureStatusBarMenuItem);
            m.add(configureKeyBindingsMenuItem);
            m.addSeparator();
            m.add(configureApplicationTreeMenuItem);
            m.add(configureResMedicinaeMenuItem);

        } else {

            throw new NullPointerException("Could not create settings menu. The settings menu is null.");
        }

        return m;
    }

    //
    // Window menu.
    //
    
    /**
     * Creates window menu.
     *
     * @param v the view owning this menu bar
     * @return the window menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createWindowMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
        ResMenuItem iconifyAllMenuItem = new ResMenuItem();
        ResMenuItem closeMenuItem = new ResMenuItem();
        ResMenuItem closeAllMenuItem = new ResMenuItem();

        // Initialize menu items.
        if (iconifyAllMenuItem != null) {

            iconifyAllMenuItem.setText("Iconify all");
            iconifyAllMenuItem.setMnemonic(KeyEvent.VK_I);
            iconifyAllMenuItem.setControlId(MainApplication.ICONIFY_ALL_CONTROL_ID);
            iconifyAllMenuItem.setOwner(getOwner());
            iconifyAllMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create window menu. The iconify all menu item is null.");
        }

        if (closeMenuItem != null) {

            closeMenuItem.setText("Close");
            closeMenuItem.setMnemonic(KeyEvent.VK_C);
            closeMenuItem.setControlId(MainApplication.CLOSE_CONTROL_ID);
            closeMenuItem.setOwner(getOwner());
            closeMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create window menu. The close menu item is null.");
        }

        if (closeAllMenuItem != null) {

            closeAllMenuItem.setText("Close all");
            closeAllMenuItem.setMnemonic(KeyEvent.VK_A);
            closeAllMenuItem.setControlId(MainApplication.CLOSE_ALL_CONTROL_ID);
            closeAllMenuItem.setOwner(getOwner());
            closeAllMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create window menu. The close all menu item is null.");
        }

        if (m != null) {

            // Initialize window menu and add menu items.
            m.setText("Window");
            m.setMnemonic(KeyEvent.VK_W);
            m.add(iconifyAllMenuItem);
            m.add(closeMenuItem);
            m.add(closeAllMenuItem);
            m.addSeparator();
            m.add(createPlacingMenu());
            m.addSeparator();
            m.add(createModeMenu());

        } else {

            throw new NullPointerException("Could not create window menu. The window menu is null.");
        }

        return m;
    }

    /**
     * Creates placing menu.
     *
     * @param v the view owning this menu bar
     * @return the placing menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createPlacingMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
        ResMenuItem cascadeMenuItem = new ResMenuItem();
        ResMenuItem tileVerticallyMenuItem = new ResMenuItem();
        ResMenuItem tileHorizontallyMenuItem = new ResMenuItem();

        // Initialize menu items.
        if (cascadeMenuItem != null) {

            cascadeMenuItem.setText("Cascade");
            cascadeMenuItem.setMnemonic(KeyEvent.VK_C);
            cascadeMenuItem.setControlId(MainApplication.CASCADE_CONTROL_ID);
            cascadeMenuItem.setOwner(getOwner());
            cascadeMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create placing menu. The cascade menu item is null.");
        }

        if (tileVerticallyMenuItem != null) {

            tileVerticallyMenuItem.setText("Tile vertically");
            tileVerticallyMenuItem.setMnemonic(KeyEvent.VK_V);
            tileVerticallyMenuItem.setControlId(MainApplication.TILE_VERTICALLY_CONTROL_ID);
            tileVerticallyMenuItem.setOwner(getOwner());
            tileVerticallyMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create placing menu. The tile vertically menu item is null.");
        }

        if (tileHorizontallyMenuItem != null) {

            tileHorizontallyMenuItem.setText("Tile horizontally");
            tileHorizontallyMenuItem.setMnemonic(KeyEvent.VK_H);
            tileHorizontallyMenuItem.setControlId(MainApplication.TILE_HORIZONTALLY_CONTROL_ID);
            tileHorizontallyMenuItem.setOwner(getOwner());
            tileHorizontallyMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create placing menu. The tile horizontally menu item is null.");
        }

        if (m != null) {

            // Initialize placing menu and add menu items.
            m.setText("Placing");
            m.setMnemonic(KeyEvent.VK_P);
            m.add(cascadeMenuItem);
            m.add(tileVerticallyMenuItem);
            m.add(tileHorizontallyMenuItem);

        } else {

            throw new NullPointerException("Could not create placing menu. The placing menu is null.");
        }

        return m;
    }

    /**
     * Creates mode menu.
     *
     * @param v the view owning this menu bar
     * @return the mode menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createModeMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
/*??
        ResRadioButtonMenuItem setFrameDisplayMenuItem = new ResRadioButtonMenuItem();
        ResRadioButtonMenuItem setInternalFrameDisplayMenuItem = new ResRadioButtonMenuItem();
        ResRadioButtonMenuItem setTabPageDisplayMenuItem = new ResRadioButtonMenuItem();
*/
        ResMenuItem setFrameDisplayMenuItem = new ResMenuItem();
        ResMenuItem setInternalFrameDisplayMenuItem = new ResMenuItem();
        ResMenuItem setTabPageDisplayMenuItem = new ResMenuItem();

        // Initialize menu items.
        if (setFrameDisplayMenuItem != null) {

            setFrameDisplayMenuItem.setText("Set Frame Display");
            setFrameDisplayMenuItem.setMnemonic(KeyEvent.VK_F);
            setFrameDisplayMenuItem.setControlId(MainApplication.SET_FRAME_DISPLAY_CONTROL_ID);
            setFrameDisplayMenuItem.setOwner(getOwner());
            setFrameDisplayMenuItem.setEnabled(true);
            //?? Temporary!
            setFrameDisplayMenuItem.addActionListener((MainApplication) getController());
            setFrameDisplayMenuItem.setActionCommand(MainApplication.SET_FRAME_DISPLAY_CONTROL_ID);

        } else {

            throw new NullPointerException("Could not create mode menu. The set frame display menu item is null.");
        }

        if (setInternalFrameDisplayMenuItem != null) {

            setInternalFrameDisplayMenuItem.setText("Set Internal Frame Display");
            setInternalFrameDisplayMenuItem.setMnemonic(KeyEvent.VK_I);
            setInternalFrameDisplayMenuItem.setControlId(MainApplication.SET_INTERNAL_FRAME_DISPLAY_CONTROL_ID);
            setInternalFrameDisplayMenuItem.setOwner(getOwner());
            setInternalFrameDisplayMenuItem.setEnabled(true);
            //?? Temporary!
            setFrameDisplayMenuItem.addActionListener((MainApplication) getController());
            setFrameDisplayMenuItem.setActionCommand(MainApplication.SET_INTERNAL_FRAME_DISPLAY_CONTROL_ID);

        } else {

            throw new NullPointerException("Could not create mode menu. The set internal frame display menu item is null.");
        }

        if (setTabPageDisplayMenuItem != null) {

            setTabPageDisplayMenuItem.setText("Set Tab Page Display");
            setTabPageDisplayMenuItem.setMnemonic(KeyEvent.VK_T);
            setTabPageDisplayMenuItem.setControlId(MainApplication.SET_TAB_PAGE_DISPLAY_CONTROL_ID);
            setTabPageDisplayMenuItem.setOwner(getOwner());
            setTabPageDisplayMenuItem.setEnabled(true);
            //?? Temporary!
            setFrameDisplayMenuItem.addActionListener((MainApplication) getController());
            setFrameDisplayMenuItem.setActionCommand(MainApplication.SET_TAB_PAGE_DISPLAY_CONTROL_ID);

        } else {

            throw new NullPointerException("Could not create mode menu. The set tab page display menu item is null.");
        }

        if (m != null) {

            // Initialize mode menu and add menu items.
            m.setText("Mode");
            m.setMnemonic(KeyEvent.VK_M);
            m.add(setFrameDisplayMenuItem);
            m.add(setInternalFrameDisplayMenuItem);
            m.add(setTabPageDisplayMenuItem);

        } else {

            throw new NullPointerException("Could not create mode menu. The mode menu is null.");
        }

        return m;
    }

    //
    // Help menu.
    //
    
    /**
     * Creates help menu.
     *
     * @param v the view owning this menu bar
     * @return the help menu
     * @exception NullPointerException if the menu or some menu item is null
     */
    private ResMenu createHelpMenu() throws NullPointerException {

        // Create menu and its menu items.
        ResMenu m = new ResMenu();
        ResMenuItem showContentsMenuItem = new ResMenuItem();
        ResMenuItem reportBugMenuItem = new ResMenuItem();
        ResMenuItem informAboutResMedicinaeMenuItem = new ResMenuItem();

        // Initialize menu items.
        if (showContentsMenuItem != null) {

            showContentsMenuItem.setText("Show Contents...");
            showContentsMenuItem.setMnemonic(KeyEvent.VK_C);
            showContentsMenuItem.setControlId(MainApplication.SHOW_HELP_CONTENTS_CONTROL_ID);
            showContentsMenuItem.setOwner(getOwner());
            showContentsMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create help menu. The show contents menu item is null.");
        }

        if (reportBugMenuItem != null) {

            reportBugMenuItem.setText("Report Bug...");
            reportBugMenuItem.setMnemonic(KeyEvent.VK_R);
            reportBugMenuItem.setControlId(MainApplication.REPORT_BUG_CONTROL_ID);
            reportBugMenuItem.setOwner(getOwner());
            reportBugMenuItem.setEnabled(false);

        } else {

            throw new NullPointerException("Could not create help menu. The report bug menu item is null.");
        }

        if (informAboutResMedicinaeMenuItem != null) {

            informAboutResMedicinaeMenuItem.setText("Inform About ResMedicinae...");
            informAboutResMedicinaeMenuItem.setMnemonic(KeyEvent.VK_A);
            informAboutResMedicinaeMenuItem.setControlId(AboutDialog.CREATE_ABOUT_DIALOG_CONTROL_ID);
            informAboutResMedicinaeMenuItem.setOwner(getOwner());
            informAboutResMedicinaeMenuItem.setEnabled(true);
            //?? Temporary!
            informAboutResMedicinaeMenuItem.addActionListener((MainApplication) getController());
            informAboutResMedicinaeMenuItem.setActionCommand(AboutDialog.CREATE_ABOUT_DIALOG_CONTROL_ID);

        } else {

            throw new NullPointerException("Could not create help menu. The inform about res medicinae menu item is null.");
        }

        if (m != null) {

            // Initialize help menu and add menu items.
            m.setText("Help");
            m.setMnemonic(KeyEvent.VK_H);
            m.add(showContentsMenuItem);
            m.addSeparator();
            m.add(reportBugMenuItem);
            m.addSeparator();
            m.add(informAboutResMedicinaeMenuItem);

        } else {

            throw new NullPointerException("Could not create help menu. The help menu is null.");
        }

        return m;
    }

    //
    // Initializable.
    //
    
    /**
     * Initializes this component.
     */
    public void initialize() throws Exception {

/*??
        // Determine application tree model.
        TreeModel m = main.getAvailableApplications();

        if (m != null) {

            // Register this menu bar as tree model listener.
            m.addTreeModelListener(this);
        }

        // Set application tree model.
        setApplicationTreeModel(m);
*/

        setApplicationMenu(createApplicationMenu());

        // Add menus to menu bar.
        add(getApplicationMenu());
        add(createEditorMenu());
        add(createViewMenu());
        add(createContextMenu());
        add(createSettingsMenu());
        add(createWindowMenu());
        add(createHelpMenu());
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() throws Exception {
    }
    
    //
    // Only temporary testing for event handling.
    //
    
    /**
     * Invoked after a node (or a set of siblings) has changed in some way.
     *
     * The node(s) have not changed locations in the tree or altered their children arrays,
     * but other attributes have changed and may affect presentation.
     * Example: the name of a file has changed, but it is in the same location in the file system.
     *
     * To indicate the root has changed, childIndices and children will be null.
     * Use e.getPath() to get the parent of the changed node(s).
     * e.getChildIndices() returns the index(es) of the changed node(s).
     *
     * @param evt the tree model event
     */
/*??
    public void treeNodesChanged(TreeModelEvent evt) {

//??        getLogger().log(Level.CONFIG, "Update menu bar.");
        updateMenuBar();
    }

    /**
     * Invoked after nodes have been inserted into the tree.
     *
     * Use e.getPath() to get the parent of the new node(s).
     * e.getChildIndices() returns the index(es) of the new node(s) in ascending order.
     *
     * @param evt the tree model event
     */
/*??
    public void treeNodesInserted(TreeModelEvent evt) {

//??        getLogger().log(Level.CONFIG, "Update menu bar.");
        updateMenuBar();
    }

    /**
     * Invoked after nodes have been removed from the tree.
     *
     * Note that if a subtree is removed from the tree, this method may only be invoked once
     * for the root of the removed subtree, not once for each individual set of siblings removed.
     *
     * Use e.getPath() to get the former parent of the deleted node(s).
     * e.getChildIndices() returns, in ascending order, the index(es) the node(s) had before being deleted.
     *
     * @param evt the tree model event
     */
/*??
    public void treeNodesRemoved(TreeModelEvent evt) {

//??        getLogger().log(Level.CONFIG, "Update menu bar.");
        updateMenuBar();
    }

    /**
     * Invoked after the tree has drastically changed structure from a given node down.
     * If the path returned by e.getPath() is of length one and the first element does not
     * identify the current root node, the first element should become the new root of the tree.
     *
     * Use e.getPath() to get the path to the node. e.getChildIndices() returns null.
     *
     * @param evt the tree model event
     */
/*??
    public void treeStructureChanged(TreeModelEvent evt) {

//??        getLogger().log(Level.CONFIG, "Update menu bar.");
        updateMenuBar();
    }

    /**
     * Updates menu bar.
     */
/*??
    private void updateMenuBar() {

        try {

//??            getLogger().log(Level.CONFIG, "Determine application menu index.");
            int i = getComponentIndex(getApplicationMenu());

//??            getLogger().log(Level.CONFIG, "Delete application menu.");
            remove(i);

//??            getLogger().log(Level.CONFIG, "Create new application menu.");
            ResMenu m = createApplicationMenu();

//??            getLogger().log(Level.CONFIG, "Insert application menu.");
//??            insert(m);

        } catch (Exception e) {

//??            getLogger().log(Level.SEVERE, "Exception", e);
        }
    }
*/
}

