/*
 * $RCSfile: MainApplicationConfiguration.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.common.main;

import java.lang.*;
import java.util.*;
import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.control.*;

/**
 * This class represents the main application configuration.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:33 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class MainApplicationConfiguration extends Configuration {

    //
    // Preference keys for the application.
    //

    /** The available applications count. */
    static final String AVAILABLE_APPLICATIONS_COUNT = "available_applications_count";

    /** The available applications. */
    static final String AVAILABLE_APPLICATIONS = "available_applications";

    /** The opened applications. */
    static final String OPENED_APPLICATIONS = "opened_applications";

    /** The external applications. */
    static final String EXTERNAL_APPLICATIONS = "external_applications";

    //
    // Available applications count.
    //

    /*
     * Returns the number of available applications.
     *
     * @return the number of available applications
     */
    private int getAvailableApplicationsCount() {

        return getPreferences().getInt(MainApplicationConfiguration.AVAILABLE_APPLICATIONS_COUNT, 0);
    }

    /*
     * Sets the number of available applications.
     *
     * @param c the number of available applications
     */
    private void setAvailableApplicationsCount(int c) {

        getPreferences().putInt(MainApplicationConfiguration.AVAILABLE_APPLICATIONS_COUNT, c);
    }

    //
    // Available applications.
    //

    /*
     * Builds an application tree from the given string array.
     *
     * @param s the string array containing all tree node parameters
     * @return the application tree
     */
    public String[] getAvailableApplications() {

        int count = getAvailableApplicationsCount();
        String[] s = new String[count];

        for (int i = 0; i < count; i++) {

            s[i] = getPreferences().get(MainApplicationConfiguration.AVAILABLE_APPLICATIONS + "_" + Integer.toString(i), "");
        }

        return s;
    }

    /*
     * Sets the tree of available applications.
     *
     * @param n the tree of available applications
     */
    public void setAvailableApplications(ApplicationTreeNode n) {

        if (n != null) {

            Enumeration enum = n.depthFirstEnumeration();

            if (enum != null) {

                Object o;
                int i = -1;

                while (enum.hasMoreElements() == true) {

                    o = enum.nextElement();
                    i = i + 1;

                    if (o != null) {

                        getPreferences().put(MainApplicationConfiguration.AVAILABLE_APPLICATIONS + "_" + Integer.toString(i), o.toString());
                    }
                }
            }
        }
    }

    //
    // Opened applications.
    //

    /*
     * Returns the list of opened applications.
     *
     * @param l the default list of opened applications
     * @return the list of opened applications
     */
    public List getOpenedApplications(/*??List l*/) {

//??        if (l == null) {

            List l = new Vector();
            String s;

            for (int i = 0; i < 2; i++) {

//??                s = getPreferences().get(MainApplicationConfiguration.OPENED_APPLICATIONS + "_" + Integer.toString(i), "");
                s = "";

                if ((s != null) && !s.equals("")) {

                    l.add(s);
                }
            }
//??        }

        return l;
    }

    /*
     * Sets the list of opened applications.
     *
     * @param l the list of opened applications
     */
    public void setOpenedApplications(List l) {

        if (l != null) {

            Object o;

            for (int i = 0; i < l.size(); i++) {

                o = l.get(i);

                if (o != null) {

                    getPreferences().put(MainApplicationConfiguration.OPENED_APPLICATIONS + "_" + Integer.toString(i), o.getClass().getName());
                }
            }
        }
    }

    //
    // Opened external applications.
    //

    /*
     * Returns the list of external applications.
     *
     * @param l the list of external applications
     * @return the list of external applications
     */
    public List getExternalApplications(/*??List l*/) {

//??        if (l == null) {

            List l = new Vector();
            String s;

            for (int i = 0; i < 2; i++) {

//??                s = getPreferences().get(MainApplicationConfiguration.EXTERNAL_APPLICATIONS + "_" + Integer.toString(i), "");
                s = "";

                if ((s != null) && !s.equals("")) {

                    l.add(s);
                }
            }
//??        }

        return l;
    }

    /*
     * Sets the list of external applications.
     *
     * @param l the list of external applications
     */
    public void setExternalApplications(List l) {

        if (l != null) {

            Object o;

            for (int i = 0; i < l.size(); i++) {

                o = l.get(i);

                if (o != null) {

                    getPreferences().put(MainApplicationConfiguration.EXTERNAL_APPLICATIONS + "_" + Integer.toString(i), o.getClass().getName());
                }
            }
        }
    }
}

