/*
 * $RCSfile: ApplicationTreeNode.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.common.main;

import java.lang.*;
import java.util.*;
import javax.swing.tree.*;

/**
 * This class represents an application tree node.
 *
 * @version $Revision: 1.1 $ $Date: 2002/06/06 18:19:48 $ $Author: chrissy $
 * @author Christian Heller
 */
public class ApplicationTreeNode extends /*?? ComponentImpl*/ DefaultMutableTreeNode {

    //
    // Attributes.
    //

    /** The external application flag. */
    private boolean external;

    /** The location. */
    private String location;

    /** The command. */
    private String command;

    /** The arguments. */
    private String[] arguments;

    /** The work path. */
    private String workPath;

    //
    // Constructor.
    //

    /**
     * Constructs application tree node.
     *
     * @param s the name
     */
    public ApplicationTreeNode(String name) {

        super(name);
    }

    //
    // External flag.
    //

    /**
     * Returns the external application flag.
     *
     * @return the external application flag
     */
    public boolean isExternal() {

        return this.external;
    }

    /**
     * Sets the external application flag.
     *
     * @param external the external application flag
     */
    public void setExternal(boolean external) {

        this.external = external;
    }

    //
    // Location.
    //

    /**
     * Returns the location.
     *
     * @return the location
     */
    public String getLocation() {

        return this.location;
    }

    /**
     * Sets the location.
     *
     * @param location the location
     */
    public void setLocation(String location) {

        this.location = location;
    }

    //
    // Command.
    //

    /**
     * Returns the command.
     *
     * @return the command
     */
    public String getCommand() {

        return this.command;
    }

    /**
     * Sets the command.
     *
     * @param command the command
     */
    public void setCommand(String command) {

        this.command = command;
    }

    //
    // Arguments.
    //

    /**
     * Returns the arguments.
     *
     * @return the arguments
     */
    public String[] getArguments() {

        return this.arguments;
    }

    /**
     * Sets the arguments.
     *
     * @param arguments the arguments
     */
    public void setArguments(String[] arguments) {

        this.arguments = arguments;
    }

    //
    // Work path.
    //

    /**
     * Returns the work path.
     *
     * @return the work path
     */
    public String getWorkPath() {

        return this.workPath;
    }

    /**
     * Sets the work path.
     *
     * @param workPath the work path
     */
    public void setWorkPath(String workPath) {

        this.workPath = workPath;
    }

    //
    // Clonable.
    //

    /**
     * Clones this tree node.
     *
     * @return the cloned tree node
     */
    public Object clone() {

        return (ApplicationTreeNode) super.clone();
    }

//?? ----------
    /*
     * Returns the index of the child node.
     *
     * @param child the child
     * @return the index of the child node
     */
/*??
    public int index(CategoryTreeNode child) {

        int count = childCount();

        for (int i = 0; i < count; i++) {

            CategoryTreeNode n = this.child(i);

            if (child.getNode() == n.getNode())

                return i;
        }

        return -1;
    }

    /*
     * Returns the child node.
     *
     * @param index the search index
     * @return the child node
     */
/*??
    public CategoryTreeNode child(int index) {

        // Note: JTree index is zero-based.
        Node node = this.node.getChildNodes().item(index);

        return new DefaultCategoryTreeNode(node, "test");
    }

    /*
     * Returns the number of children.
     *
     * @return the number of children
     */
/*??
    public int childCount() {

        return this.node.getChildNodes().getLength();
    }

    /**
     * Clones this default category tree node.
     *
     * @return the cloned default category tree node
     */
/*??
    public Object clone() {

        Object o = null;

        try {

            getLogger().log(Level.CONFIG, "Clone this default category tree node.");
            o = (DefaultCategoryTreeNode) super.clone();

        } catch (java.lang.CloneNotSupportedException e) {

            getLogger().log(Level.SEVERE, "Exception", e);
        }

        return o;
    }

    /**
     * Creates a copy of this category tree node.
     *
     * @return the copy of this category tree node
     * @exception if no copy of this category tree node could be created
     */
/*??
    public CategoryTreeNode copy() throws Exception {

/*??
        getLogger().log(Level.CONFIG, "Create category tree node.");
        DefaultCategoryTreeNode n = (DefaultCategoryTreeNode) clone();

        if (n != null) {

            CategoryTreeNode child = null;

            for (int i = 0; i < getChildCount(); i++) {

                getLogger().log(Level.CONFIG, "Determine child.");
                child = (CategoryTreeNode) getChildAt(i);

                try {

                    getLogger().log(Level.CONFIG, "Add child copy.");
                    n.add(child.copy());

                } catch (Exception e) {

                    getLogger().log(Level.SEVERE, "Exception", e);
                }
            }

            getLogger().log(Level.CONFIG, "Determine user object.");
            String userObject = (String) getUserObject();

            try {

                getLogger().log(Level.CONFIG, "Set cloned user object.");
                n.setUserObject(userObject);

            } catch (Exception e) {

                getLogger().log(Level.SEVERE, "Exception", e);
            }

        } else {

            throw new Exception("Cannot copy tree node. Created default category tree node is null.");
        }

        return n;
    }
*/
}

