/*
 * $RCSfile: ApplicationRunner.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.common.main;

import java.lang.*;
import org.resmedicinae.application.common.basic.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.component.*;
import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.logger.*;
import org.resmedicinae.resmedlib.component.model.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents an application runner.
 *
 * Its only task is to startup and shutdown an application.
 * It uses the normal <code>createApplication</code> method of the parent class.
 * The <code>destroyApplication</code> method, however, is overloaded to exit
 * the whole system when this application gets destroyed.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:33 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ApplicationRunner extends MainApplication {

    //
    // Application.
    //

    /**
     * Destroys the application.
     *
     * @param c the application controller
     */
    public void destroyApplication(BasicApplication c) throws Exception {

        try {

            super.destroyApplication(c);

        } finally {

            //
            // Runtime.getRuntime().exit(0);
            // and
            // System.exit(0);
            // do the same thing.
            // The program exits normally, when the last non-daemon thread exits.
            //
            log(Level.INFO, "Exit system.");
            Runtime.getRuntime().exit(0);
        }
    }

    //
    // Splash window.
    //

    /**
     * Shows the component splash window.
     *
     * @param c the component splash window
     * @exception NullPointerException if the component is null
     */
    private void showComponentSplashWindow(BasicApplication c) throws Exception, NullPointerException {

        if (c != null) {

//??            if (c instanceof Splashable) {

            log(Level.INFO, "Show the component splash window.");
//??            c.setSplashWindowController(c.getDefaultSplashWindowController());
//??            c.showSplashWindowController(c.getSplashWindowController());
//??            }

        } else {

            throw new NullPointerException("Could not show component splash window. The component is null.");
        }
    }

    /**
     * Disposes the component splash window.
     *
     * @param c the component splash window
     * @exception NullPointerException if the component is null
     */
    private void hideComponentSplashWindow(BasicApplication c) throws Exception, NullPointerException {

        if (c != null) {

//??            if (c instanceof Splashable) {

            log(Level.INFO, "Hide the component splash window.");
//??            c.hideSplashWindowController(c.getSplashWindowController());
//??            c.destroySplashWindowController(c.getSplashWindowController());
//??            c.setSplashWindowController(null);
//??            }

        } else {

            throw new NullPointerException("Could not hide component splash window. The component is null.");
        }
    }
}

