/*
 * $RCSfile: BasicApplication.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.common.basic;

import java.awt.event.*;
import java.lang.*;
import java.util.prefs.*;
import org.resmedicinae.application.controller.about.*;
import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.application.controller.login.*;
import org.resmedicinae.application.controller.splash.*;
import org.resmedicinae.resmedlib.component.component.*;
import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.logger.*;
import org.resmedicinae.resmedlib.component.model.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

/**
 * This class represents a basic application.
 *
 * Classes inheriting from this class can be run standalone or
 * belonging to a main (parent) application.
 *
 * Design patterns:
 * - Controller in Model View Controller
 *
 * @version $Revision: 1.5 $ $Date: 2002/08/09 21:12:40 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class BasicApplication extends BasicController {

    //
    // Constants.
    //

    /** The create application control id. */
    public static final String CREATE_APPLICATION_CONTROL_ID = "create_application";

    /** The destroy application control id. */
    public static final String DESTROY_APPLICATION_CONTROL_ID = "destroy_application";

    /** The cut control id. */
    public static final String CUT_CONTROL_ID = "cut";

    /** The copy control id. */
    public static final String COPY_CONTROL_ID = "copy";

    /** The paste control id. */
    public static final String PASTE_CONTROL_ID = "paste";

    /** The show tool bar control id. */
    public static final String SHOW_TOOL_BAR_CONTROL_ID = "show_tool_bar";

    /** The show status bar control id. */
    public static final String SHOW_STATUS_BAR_CONTROL_ID = "show_status_bar";

    /** The configure menu bar control id. */
    public static final String CONFIGURE_MENU_BAR_CONTROL_ID = "configure_menu_bar";

    /** The configure tool bar control id. */
    public static final String CONFIGURE_TOOL_BAR_CONTROL_ID = "configure_tool_bar";

    /** The configure status bar control id. */
    public static final String CONFIGURE_STATUS_BAR_CONTROL_ID = "configure_status_bar";

    /** The configure key bindings control id. */
    public static final String CONFIGURE_KEY_BINDINGS_CONTROL_ID = "configure_key_bindings";

    /** The show help contents control id. */
    public static final String SHOW_HELP_CONTENTS_CONTROL_ID = "show_help_contents";

    /** The report bug control id. */
    public static final String REPORT_BUG_CONTROL_ID = "report_bug";

    /** The link to website control id. */
    public static final String LINK_TO_WEBSITE_CONTROL_ID = "link_to_website";

    //
    // Application description.
    //

    /** The slogan. */
    private String slogan;

    /** The description. */
    private String description;

    //
    // Dialogs.
    //

    /** The splash window. */
    private SplashWindow splashWindow;

    /** The login dialog. */
    private LoginDialog loginDialog;

    /** The about dialog. */
    private AboutDialog aboutDialog;

    /** The user. */
    private User user;

    //
    // Name.
    //

    /**
     * Returns the name.
     *
     * @return the name
     */
    public String getName() {

        return "Unnamed Application";
    }

    //
    // Version.
    //

    /**
     * Returns the version.
     *
     * (major).(minor).(<99 = preX, 99 = final).(bug fix)
     *
     * @return the version
     */
    public String getVersion() {

        return "Unspecified Version";
    }

    //
    // Date.
    //

    /**
     * Returns the release date.
     *
     * @return the release date
     */
    public String getDate() {

        return "Unspecified Date";
    }

    //
    // Slogan.
    //

    /**
     * Returns the slogan.
     *
     * @return the slogan
     */
    public String getSlogan() {

        return this.slogan;
    }

    /**
     * Sets the slogan.
     *
     * @param slogan the slogan
     */
    public void setSlogan(String slogan) {

        this.slogan = slogan;
    }

    /**
     * Creates a slogan.
     *
     * @return the slogan
     */
    public String createSlogan() {

        return "- Information in Medicine -";
    }

    /*
     * Destroys the slogan.
     *
     * @param s the slogan
     */
    public void destroySlogan(String s) {
    }

    //
    // Logo.
    //

    /**
     * Returns the logo.
     *
     * @return the logo
     */
    public String getLogo() {

        return "Unspecified logo";
    }

    //
    // Copyright.
    //

    /**
     * Returns the copyright.
     *
     * @return the copyright
     */
    public String getCopyright() {

        return "Copyright (c) 1999-2002. Christian Heller. All rights reserved.";
    }

    //
    // Contact.
    //

    /**
     * Returns the contact.
     *
     * @return the contact
     */
    public String getContact() {

        return "http://www.resmedicinae.org";
    }

    //
    // Description.
    //

    /**
     * Returns the description.
     *
     * @return the description
     */
    public String getDescription() {

        return this.description;
    }

    /**
     * Sets the description.
     *
     * @param description the description
     */
    public void setDescription(String description) {

        this.description = description;
    }

    /**
     * Creates a description.
     *
     * @return the description
     */
    public String createDescription() {

        return "Free Medical Information System";
    }

    /*
     * Destroys the description.
     *
     * @param d the description
     */
    public void destroyDescription(String d) {
    }

    //
    // Authors.
    //

    /**
     * Returns the authors.
     *
     * @return the authors
     */
    public String getAuthors() {

        return "Unspecified Authors.\n"
            + "Try to contact these project administrators:\n\n"
            + "Christian Heller\n<christian.heller@tuxtax.de>\n\n"
            + "Karsten Hilbert\n<karsten.hilbert@gmx.net>";
    }

    //
    // Helpers.
    //

    /**
     * Returns the helpers.
     *
     * @return the helpers
     */
    public String getHelpers() {

        return "Unspecified Helpers.\n"
            + "Try to contact these project administrators:\n\n"
            + "Christian Heller\n<christian.heller@tuxtax.de>\n\n"
            + "Karsten Hilbert\n<karsten.hilbert@gmx.net>";
    }

    //
    // Inspirations.
    //

    /**
     * Returns the inspirations.
     *
     * @return the inspirations
     */
    public String getInspirations() {

        return "Unspecified Inspirations";
    }

    //
    // License.
    //

    /**
     * Returns the license.
     *
     * @return the license
     */
    public String getLicense() {

        return "This software is published under the GPL GNU General Public License.\n"
            + "This program is free software; you can redistribute it and/or\n"
            + "modify it under the terms of the GNU General Public License\n"
            + "as published by the Free Software Foundation; either version 2\n"
            + "of the License, or (at your option) any later version.\n\n"
            + "This program is distributed in the hope that it will be useful,\n"
            + "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
            + "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
            + "GNU General Public License for more details.\n\n"
            + "You should have received a copy of the GNU General Public License\n"
            + "along with this program; if not, write to the Free Software\n"
            + "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n"
            + "Find the GPL license and more information at: http://www.gnu.org";
    }

    //
    // Splash window.
    //

    /*
     * Returns the splash window.
     *
     * @return the splash window
     */
    public SplashWindow getSplashWindow() {

        return this.splashWindow;
    }

    /*
     * Sets the splash window.
     *
     * @param splashWindow the splash window
     */
    public void setSplashWindow(SplashWindow splashWindow) {

        this.splashWindow = splashWindow;
    }

    /**
     * Creates the splash window.
     *
     * @return the splash window
     */
    public SplashWindow createSplashWindow() throws Exception {

        SplashWindow c = new SplashWindow();

        // Bring component through birth process.
        bear(c);

        return c;
    }

    /**
     * Destroys the splash window.
     *
     * @param c the splash window
     */
    public void destroySplashWindow(SplashWindow c) throws Exception {

        // Bring component through death process.
        kill(c);
    }

    /**
     * Advances the splash window.
     *
     * Prints out a message using the logger.
     *
     * @param step the value to set the progress bar to
     * @param msg the message
     */
    public void advanceSplashWindow(int step, String msg) throws Exception {

        SplashWindow sw = getSplashWindow();

        if (sw != null) {

            sw.advance(step, msg);
        }
    }

    //
    // Login dialog.
    //

    /**
     * Returns the login dialog.
     *
     * @return the login dialog
     */
    public LoginDialog getLoginDialog() {

        return this.loginDialog;
    }

    /**
     * Sets the login dialog.
     *
     * @param loginDialog the login dialog
     */
    public void setLoginDialog(LoginDialog loginDialog) {

        this.loginDialog = loginDialog;
    }

    /**
     * Creates the login dialog.
     *
     * @exception NullPointerException if the login dialog is null
     */
    public LoginDialog createLoginDialog() throws Exception, NullPointerException {

        LoginDialog c = new LoginDialog();

        // Bring component through birth process.
        bear(c);

        return c;
    }

    /**
     * Destroys the login dialog.
     *
     * @exception NullPointerException if the login dialog is null
     */
    public void destroyLoginDialog(LoginDialog c) throws Exception, NullPointerException {

        // Bring component through death process.
        kill(c);
    }

    //
    // About dialog.
    //

    /**
     * Returns the about dialog.
     *
     * @return the about dialog
     */
    public AboutDialog getAboutDialog() {

        return this.aboutDialog;
    }

    /**
     * Sets the about dialog.
     *
     * @param aboutDialog the about dialog
     */
    public void setAboutDialog(AboutDialog aboutDialog) {

        this.aboutDialog = aboutDialog;
    }

    /**
     * Creates the about dialog.
     *
     * @exception NullPointerException if the context is null
     */
    private AboutDialog createAboutDialog() throws Exception, NullPointerException {

        AboutDialog c = new AboutDialog();

        Context ctxt = getContext();

        if (ctxt != null) {

            ctxt.putEntry("name", getName());
            ctxt.putEntry("version", getVersion());
            ctxt.putEntry("date", getDate());
            ctxt.putEntry("slogan", getSlogan());
            ctxt.putEntry("logo", getLogo());
            ctxt.putEntry("copyright", getCopyright());
            ctxt.putEntry("contact", getContact());
            ctxt.putEntry("description", getDescription());
            ctxt.putEntry("authors", getAuthors());
            ctxt.putEntry("helpers", getHelpers());
            ctxt.putEntry("inspirations", getInspirations());
            ctxt.putEntry("license", getLicense());

        } else {

            throw new NullPointerException("Could not create about dialog. The context is null.");
        }

        bear(c);

        return c;
    }

    /**
     * Destroys the about dialog.
     *
     * @param c the about dialog
     */
    private void destroyAboutDialog(AboutDialog c) throws Exception {

        kill(c);
    }

    //
    // User.
    //

    /**
     * Returns the user.
     *
     * @return the user
     */
    public User getUser() {

        return this.user;
    }

    /**
     * Sets the user.
     *
     * @param user the user
     */
    public void setUser(User user) {

        this.user = user;
    }

    /**
     * Creates a user.
     *
     * @return the user
     */
    public User createUser() throws Exception {

        User u = new User();

        if (u != null) {

/*??
        LoginDialog c = new LoginDialog();

        // Bring component through birth process.
        bear(c);
*/

            // Bring component through birth process.
//??            bear(u);

        } else {

            throw new NullPointerException("Could not create user. The user is null.");
        }

        return u;
    }

    /**
     * Destroys the user.
     *
     * @param u the user
     */
    public void destroyUser(User u) throws Exception {

        // Bring component through death process.
        kill(u);
    }

    //
    // Context.
    //
    
    /**
     * Creates a context.
     *
     * @return the context
     * @exception NullPointerException if the context is null
     */
    public Context createContext() throws Exception, NullPointerException {

        Context c = new Context();

        if (c != null) {
                
            c.initialize();
            
        } else {
            
            throw new NullPointerException("Could not create context. The context is null.");
        }

        return c;
    }

    /**
     * Destroys the context.
     *
     * @param c the context
     * @exception NullPointerException if the context is null
     */
    public void destroyContext(Context c) throws Exception, NullPointerException {

        if (c != null) {
                
            c.finalizz();
            
        } else {
            
            throw new NullPointerException("Could not destroy context. The context is null.");
        }
    }

    //
    // Component manager.
    //
    
    /**
     * Creates a component manager.
     *
     * @return the component manager
     * @exception NullPointerException if the component manager is null
     */
    public ComponentManager createComponentManager() throws Exception, NullPointerException {

        ComponentManager m = new ComponentManager();

        if (m != null) {

            m.initialize();

        } else {

            throw new NullPointerException("Could not create component manager. The component manager is null.");
        }

        return m;
    }

    /**
     * Destroys the component manager.
     *
     * @param m the component manager
     * @exception NullPointerException if the component manager is null
     */
    public void destroyComponentManager(ComponentManager m) throws Exception, NullPointerException {

        if (m != null) {

            m.finalizz();

        } else {

            throw new NullPointerException("Could not destroy component manager. The component manager is null.");
        }
    }

    //
    // Configuration manager.
    //
    
    /**
     * Creates a configuration manager.
     *
     * @return the configuration manager
     * @exception NullPointerException if the configuration manager is null
     */
    public ConfigurationManager createConfigurationManager() throws Exception, NullPointerException {

        ConfigurationManager m = new ConfigurationManager();

        if (m != null) {

            m.initialize();
            m.setSystemConfiguration(createSystemConfiguration());
            m.setLocalConfiguration(createLocalConfiguration());
            m.setUserConfiguration(createUserConfiguration());

        } else {

            throw new NullPointerException("Could not create sub configurations. The configuration manager is null.");
        }

        return m;
    }

    /**
     * Destroys the configuration manager.
     *
     * @param m the configuration manager
     * @exception NullPointerException if the configuration manager is null
     */
    public void destroyConfigurationManager(ConfigurationManager m) throws Exception, NullPointerException {

        if (m != null) {

            destroyUserConfiguration(m.getUserConfiguration());
            m.setUserConfiguration(null);
            destroyLocalConfiguration(m.getLocalConfiguration());
            m.setLocalConfiguration(null);
            destroySystemConfiguration(m.getSystemConfiguration());
            m.setSystemConfiguration(null);
            m.finalizz();

        } else {

            throw new NullPointerException("Could not destroy configuration manager. The configuration manager is null.");
        }
    }

    //
    // System configuration.
    //

    /*
     * Creates the system configuration.
     *
     * @return the system configuration
     * @exception NullPointerException if the system configuration is null
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the system preferences is null
     * @exception NullPointerException if the system configuration location is null
     */
    protected Configuration createSystemConfiguration() throws Exception, NullPointerException {

        Configuration c = new Configuration();

        if (c != null) {

            Context ctxt = getContext();

            if (ctxt != null) {

                Preferences p = Preferences.systemNodeForPackage(getClass());
                Object l = ctxt.getEntry("system_configuration_location");

                // Has to be checked for null here, even if no method call on p.
                // Context map cannot take null parameters.
                if (p != null) {

                    ctxt.putEntry("preferences", p);

                } else {

                    throw new NullPointerException("Could not put system preferences to context. The system preferences is null.");
                }

                // Has to be checked for null here, even if no method call on l.
                // Context map cannot take null parameters.
                if (l != null) {

                    ctxt.putEntry("location", l);

                } else {

                    throw new NullPointerException("Could not put system configuration location to context. The system configuration location is null.");
                }

                c.contextualize(ctxt);
                c.initialize();

            } else {

                throw new NullPointerException("Could not create system configuration. The context is null.");
            }

        } else {

            throw new NullPointerException("Could not create system configuration. The system configuration is null.");
        }

        return c;
    }

    /*
     * Destroys the system configuration.
     *
     * @param c the system configuration
     */
    protected void destroySystemConfiguration(Configuration c) throws Exception {

        // Bring component through death process.
        kill(c);
    }

    //
    // Local configuration.
    //

    /*
     * Creates the local configuration.
     *
     * @return the local configuration
     * @exception NullPointerException if the local configuration is null
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the local preferences is null
     * @exception NullPointerException if the local configuration location is null
     */
    protected Configuration createLocalConfiguration() throws Exception, NullPointerException {

        Configuration c = new Configuration();

        if (c != null) {

            Context ctxt = getContext();

            if (ctxt != null) {

                Preferences p = Preferences.systemNodeForPackage(getClass());
                Object l = ctxt.getEntry("local_configuration_location");

                // Has to be checked for null here, even if no method call on p.
                // Context map cannot take null parameters.
                if (p != null) {

                    ctxt.putEntry("preferences", p);

                } else {

                    throw new NullPointerException("Could not put local preferences to context. The local preferences is null.");
                }

                // Has to be checked for null here, even if no method call on l.
                // Context map cannot take null parameters.
                if (l != null) {

                    ctxt.putEntry("location", l);

                } else {

                    throw new NullPointerException("Could not put local configuration location to context. The local configuration location is null.");
                }

                // Bring component through death process.
                c.contextualize(ctxt);
                c.initialize();

            } else {

                throw new NullPointerException("Could not create local configuration. The context is null.");
            }

        } else {

            throw new NullPointerException("Could not create local configuration. The local configuration is null.");
        }

        return c;
    }

    /*
     * Destroys the local configuration.
     *
     * @param c the local configuration
     */
    protected void destroyLocalConfiguration(Configuration c) throws Exception {

        // Bring component through death process.
        kill(c);
    }

    //
    // User configuration.
    //

    /*
     * Creates the user configuration.
     *
     * @return the user configuration
     * @exception NullPointerException if the user configuration is null
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the user preferences is null
     * @exception NullPointerException if the user configuration location is null
     */
    protected Configuration createUserConfiguration() throws Exception, NullPointerException {

        Configuration c = new Configuration();

        if (c != null) {

            Context ctxt = getContext();

            if (ctxt != null) {

                Preferences p = Preferences.userNodeForPackage(getClass());
                Object l = ctxt.getEntry("user_configuration_location");

                // Has to be checked for null here, even if no method call on p.
                // Context map cannot take null parameters.
                if (p != null) {

                    ctxt.putEntry("preferences", p);

                } else {

                    throw new NullPointerException("Could not put user preferences to context. The user preferences is null.");
                }

                // Has to be checked for null here, even if no method call on l.
                // Context map cannot take null parameters.
                if (l != null) {

                    ctxt.putEntry("location", l);

                } else {

                    throw new NullPointerException("Could not put user configuration location to context. The user configuration location is null.");
                }

                // Bring component through birth process.
                c.contextualize(ctxt);
                c.initialize();

            } else {

                throw new NullPointerException("Could not create user configuration. The context is null.");
            }

        } else {

            throw new NullPointerException("Could not create user configuration. The user configuration is null.");
        }

        return c;
    }

    /*
     * Destroys the user configuration.
     *
     * @param c the user configuration
     */
    protected void destroyUserConfiguration(Configuration c) throws Exception {

        // Bring component through death process.
        kill(c);
    }

    //
    // Logger.
    //
    
    /**
     * Creates a logger.
     *
     * @return the logger
     * @exception NullPointerException if the context is null
     */
    public Logger createLogger() throws Exception, NullPointerException {

        Logger l = new Logger();
        Context c = getContext();

        if (c != null) {

            c.putEntry("named_subsystem", getClass().getName());

        } else {

            throw new NullPointerException("Could not put logger context parameter. The context is null.");
        }

        // Bring component through birth process.
        bear(l);

        return l;
    }

    /**
     * Destroys the logger.
     *
     * @param l the logger
     */
    public void destroyLogger(Logger l) throws Exception {

        // Bring component through death process.
        kill(l);
    }

    //
    // Display manager.
    //
    
    /**
     * Creates a display manager.
     *
     * @return the display manager
     * @exception Exception if the given view context does not exist
     */
    public DisplayManager createDisplayManager() throws Exception, NullPointerException {

        DisplayManager m = null;
        int context = getViewContext();

        if (context == DisplayManager.TEXT) {

            //?? m = newTextDisplayManager();

        } else if (context == DisplayManager.SWING) {

            m = new SwingDisplayManager();

            // Bring component through birth process.
            bear(m);

        } else if (context == DisplayManager.JSP) {

//??        m = new JspDisplayManager();

        } else {

            throw new Exception("Could not create display manager. The given view context does not exist.");
        }

        return m;
    }

    /**
     * Destroys the display manager.
     *
     * @param m the display manager
     */
    public void destroyDisplayManager(DisplayManager m) throws Exception, NullPointerException {

        // Bring component through death process.
        kill(m);
    }

    //
    // Persistence manager.
    //

    /**
     * Creates a persistence manager.
     *
     * @return the persistence manager
     */
    public PersistenceManager createPersistenceManager() throws Exception, NullPointerException {

        return new PersistenceManager();
    }

    /**
     * Destroys the persistence manager.
     *
     * @param m the persistence manager
     */
    public void destroyPersistenceManager(PersistenceManager m) throws Exception, NullPointerException {
    }

    //
    // Configurable.
    //

    /**
     * Configures the system settings.
     *
     * @param c the system configuration
     * @exception NullPointerException if the system configuration is null
     */
    protected void configureSystemSettings(Configuration c) throws Exception, NullPointerException {

        super.configureSystemSettings(c);

        if (c != null) {

            setSlogan(c.getSlogan(createSlogan()));
            setDescription(c.getDescription(createDescription()));

        } else {

            throw new NullPointerException("Could not configure system settings. The system configuration is null.");
        }
    }

    /**
     * Deconfigures the system settings.
     *
     * @param c the system configuration
     * @exception NullPointerException if the system configuration is null
     */
    protected void deconfigureSystemSettings(Configuration c) throws Exception, NullPointerException {

        try {

            if (c != null) {

                c.setSlogan(getSlogan());
                c.setDescription(getDescription());

            } else {

                throw new NullPointerException("Could not deconfigure system settings. The system configuration is null.");
            }

        } finally {

            super.deconfigureSystemSettings(c);
        }
    }

    /**
     * Configures the user settings.
     *
     * @param c the user configuration
     * @exception NullPointerException if the user configuration is null
     */
    protected void configureUserSettings(Configuration c) throws Exception, NullPointerException {

        super.configureUserSettings(c);

        if (c != null) {

            setSlogan(c.getSlogan(createSlogan()));
            setDescription(c.getDescription(createDescription()));

        } else {

            throw new NullPointerException("Could not configure user settings. The user configuration is null.");
        }
    }

    /**
     * Deconfigures the user settings.
     *
     * @param c the user configuration
     * @exception NullPointerException if the user configuration is null
     */
    protected void deconfigureUserSettings(Configuration c) throws Exception, NullPointerException {

        try {

            if (c != null) {

                c.setSlogan(getSlogan());
                c.setDescription(getDescription());

            } else {

                throw new NullPointerException("Could not deconfigure user settings. The user configuration is null.");
            }

        } finally {

            super.deconfigureUserSettings(c);
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this component.
     */
    public void initialize() throws Exception {

        super.initialize();

        setLogger(createLogger());
        setDisplayManager(createDisplayManager());
        setPersistenceManager(createPersistenceManager());
        setUser(createUser());
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() throws Exception {

        try {
                
            destroyUser(getUser());
            setUser(null);
    
            destroyPersistenceManager(getPersistenceManager());
            setPersistenceManager(null);
    
            destroyDisplayManager(getDisplayManager());
            setDisplayManager(null);
            
            destroyLogger(getLogger());
            setLogger(null);
            
        } finally {

            super.finalizz();
        }
    }
    
    /**
     * Starts this component.
     */
    public void start() throws Exception {

        super.start();
        
        login(getUser());
    }

    /**
     * Stops this component.
     */
    public void stop() throws Exception {

        try {
            
            logout(getUser());
            
        } finally {
            
            super.stop();
        }
    }

    //
    // HandleEnabled.
    //

    /**
     * Handles control events and calls the corresponding methods.
     *
     * @param c the control
     * @exception NullPointerException if the control is null
     */
    protected void handle(Control c) throws Exception, NullPointerException {

        super.handle(c);

        //?? Do not change org.scopemvc.core.Control into a ResMedLib-Control!
        //?? The Scope lib issues a org.scopemvc.core.Control internal that
        //?? has to be caught here. If the method header is changed, then this
        //?? method does not override the parent method and is treated as new.

        if (c != null) {

            if (((Control) c).matches(AboutDialog.CREATE_ABOUT_DIALOG_CONTROL_ID) == true) {

                add(createAboutDialog());

            } else if (((Control) c).matches(AboutDialog.DESTROY_ABOUT_DIALOG_CONTROL_ID) == true) {

                remove((AboutDialog) c.getSender());
                destroyAboutDialog((AboutDialog) c.getSender());
            }

        } else {

            throw new NullPointerException("Could not handle control. The control is null.");
        }
    }

    /**
     * ?? Temporary, until framework provides easier handling!
     *
     * Handles all action events of the whole application.
     *
     * @param evt the action event
     */                
    public void actionPerformed(ActionEvent evt) {
    
        System.out.println("Action Command in basic app.");

        super.actionPerformed(evt);
        
        try {

            if (evt.getActionCommand().equals(AboutDialog.CREATE_ABOUT_DIALOG_CONTROL_ID)) {
    
                add(createAboutDialog());
    
            } else if (evt.getActionCommand().equals(AboutDialog.DESTROY_ABOUT_DIALOG_CONTROL_ID)) {
    
                remove((AboutDialog) evt.getSource());
                destroyAboutDialog((AboutDialog) evt.getSource());
            }
        
        } catch (Exception e) {
            
            System.out.println("?? Exception occured! " + e);
        }
    }

    //
    // Log in and out.
    //

    /**
     * Logs in the user.
     *
     * @param u the user
     * @exception NullPointerException if the user is null
     */
    public void login(User u) throws NullPointerException {

        if (u != null) {

            //?? What to do here? Reconfigure, Reinitialize, Reshow...!
/*??
            a.setUser(createUser());
            a.login(getUser());
*/

        } else {

            throw new NullPointerException("Could not login user. The user is null.");
        }
    }

    /**
     * Logs out the user.
     *
     * @param u the user
     * @exception NullPointerException if the user is null
     */
    public void logout(User u) throws NullPointerException {

        if (u != null) {

            //?? What to do here? Reconfigure, Reinitialize, Reshow...!
/*??
            c.logout(getUser());
            c.destroyUser(getUser());
            c.setUser(null);
*/

        } else {

            throw new NullPointerException("Could not logout user. The user is null.");
        }
    }
}

