/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.util.Os;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class FileExecutor {
    private Collection files;

    private final boolean stopThread(Thread thread, MonitorInputStream monitorInputStream) {
        monitorInputStream.doStop();
        long l = 1000L;
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        long l2 = 1000L;
        try {
            thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return thread.isAlive() ^ true;
    }

    public int executeCommand(String[] stringArray, String[] stringArray2) {
        Process process = null;
        MonitorInputStream monitorInputStream = null;
        MonitorInputStream monitorInputStream2 = null;
        Thread thread = null;
        Thread thread2 = null;
        int n = 0;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            InputStreamReader inputStreamReader2 = new InputStreamReader(process.getErrorStream());
            StringWriter stringWriter = new StringWriter();
            StringWriter stringWriter2 = new StringWriter();
            monitorInputStream = new MonitorInputStream(inputStreamReader, stringWriter);
            monitorInputStream2 = new MonitorInputStream(inputStreamReader2, stringWriter2);
            thread = new Thread(monitorInputStream);
            thread2 = new Thread(monitorInputStream2);
            thread.setDaemon(true);
            thread2.setDaemon(true);
            thread.start();
            thread2.start();
            n = process.waitFor();
            if (thread != null) {
                thread.join();
            }
            if (thread2 != null) {
                thread2.join();
            }
            stringArray2[0] = stringWriter.toString();
            stringArray2[1] = stringWriter2.toString();
            n = process.exitValue();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(System.err);
            this.stopThread(thread, monitorInputStream);
            this.stopThread(thread2, monitorInputStream2);
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return n;
    }

    public int executeFiles() {
        int n = 0;
        String[] stringArray = new String[2];
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("user.name").equals("root") ? "a+x" : "u+x";
        Iterator iterator = this.files.iterator();
        while (n == 0 && iterator.hasNext()) {
            String[] stringArray2;
            ExecutableFile executableFile = (ExecutableFile)iterator.next();
            File file = new File(executableFile.path);
            if (string.equals(":") && (!string2.startsWith("mac") || string2.endsWith("x"))) {
                stringArray2 = new String[]{"/bin/chmod", string3, file.toString()};
                n = this.executeCommand(stringArray2, stringArray);
            }
            stringArray2 = executableFile.osList.iterator();
            while (stringArray2.hasNext()) {
                Os os = (Os)stringArray2.next();
                if (!os.matchCurrentSystem() || n != 0 || executableFile.executionStage != 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (executableFile.type == 0) {
                    arrayList.add(file.toString());
                } else if (1 == executableFile.type && executableFile.mainClass == null) {
                    arrayList.add(System.getProperty("java.home") + "/bin/java");
                    arrayList.add("-jar");
                    arrayList.add(file.toString());
                } else if (1 == executableFile.type && executableFile.mainClass != null) {
                    arrayList.add(System.getProperty("java.home") + "/bin/java");
                    arrayList.add("-cp=" + file.toString());
                    arrayList.add(executableFile.mainClass);
                }
                if (executableFile.argList != null && !executableFile.argList.isEmpty()) {
                    arrayList.addAll(executableFile.argList);
                }
                String[] stringArray3 = new String[arrayList.size()];
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    stringArray3[n2] = (String)arrayList.get(n2);
                    ++n2;
                }
                n = this.executeCommand(stringArray3, stringArray);
                if (n == 0) continue;
                String string4 = stringArray[0] + '\n' + stringArray[1];
                if (string4.length() == 1) {
                    string4 = new String("Failed to execute " + file.toString() + '.');
                }
                if (executableFile.onFailure == 0) {
                    JOptionPane.showMessageDialog(null, string4, "Installation error", 0);
                    continue;
                }
                if (executableFile.onFailure == 1) {
                    JOptionPane.showMessageDialog(null, string4, "Installation warning", 2);
                    n = 0;
                    continue;
                }
                if (JOptionPane.showConfirmDialog(null, string4 + "Would you like to proceed?", "Installation Warning", 0) != 0) continue;
                n = 0;
            }
            if (executableFile.executionStage != 0) continue;
            file.delete();
        }
        return n;
    }

    public FileExecutor(Collection collection) {
        this.files = collection;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MonitorInputStream
    implements Runnable {
        private BufferedReader reader;
        private BufferedWriter writer;
        private boolean shouldStop;

        public void doStop() {
            this.shouldStop = true;
        }

        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    this.writer.write(string);
                    this.writer.newLine();
                    this.writer.flush();
                    if (!this.shouldStop) continue;
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }

        private final /* synthetic */ void this() {
            this.shouldStop = false;
        }

        public MonitorInputStream(Reader reader, Writer writer) {
            this.this();
            this.reader = new BufferedReader(reader);
            this.writer = new BufferedWriter(writer);
        }
    }
}

