/*
 * Copyright (C) 1999-2009. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: signal_memory_memory_name.c,v $ $Revision: 1.3 $ $Date: 2009/01/31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef SIGNAL_MEMORY_MEMORY_NAME_SOURCE
#define SIGNAL_MEMORY_MEMORY_NAME_SOURCE

#include "../../../constant/model/memory/integer_memory_model.c"

/** The abstractions signal memory memory name. */
static int* ABSTRACTIONS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_0_INTEGER_MEMORY_MODEL_ARRAY;

/** The abstractions counts signal memory memory name. */
static int* ABSTRACTIONS_COUNTS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_1_INTEGER_MEMORY_MODEL_ARRAY;

/** The models signal memory memory name. */
static int* MODELS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_2_INTEGER_MEMORY_MODEL_ARRAY;

/** The models counts signal memory memory name. */
static int* MODELS_COUNTS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_3_INTEGER_MEMORY_MODEL_ARRAY;

/** The details signal memory memory name. */
static int* DETAILS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_4_INTEGER_MEMORY_MODEL_ARRAY;

/** The details counts signal memory memory name. */
static int* DETAILS_COUNTS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The priorities signal memory memory name. */
static int* PRIORITIES_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The identifications signal memory memory name. */
static int* IDENTIFICATIONS_SIGNAL_MEMORY_MEMORY_NAME = NUMBER_7_INTEGER_MEMORY_MODEL_ARRAY;

/* SIGNAL_MEMORY_MEMORY_NAME_SOURCE */
#endif
