/*
 * Copyright (C) 1999-2009. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: tag_web_user_interface_cybol_name.c,v $ $Revision: 1.4 $ $Date: 2009/01/31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TAG_WEB_USER_INTERFACE_CYBOL_NAME_SOURCE
#define TAG_WEB_USER_INTERFACE_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../constant/model/memory/integer_memory_model.c"

/** The tag web user interface cybol name. */
static wchar_t TAG_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L't', L'a', L'g'};
static wchar_t* TAG_WEB_USER_INTERFACE_CYBOL_NAME = TAG_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* TAG_WEB_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_3_INTEGER_MEMORY_MODEL_ARRAY;

/** The property web user interface cybol name. */
static wchar_t PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'o', L'p', L'e', L'r', L't', L'y'};
static wchar_t* PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME = PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_MEMORY_MODEL_ARRAY;

/* TAG_WEB_USER_INTERFACE_CYBOL_NAME_SOURCE */
#endif
