/*
 * Copyright (C) 1999-2009. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: create_memory_operation_cybol_name.c,v $ $Revision: 1.4 $ $Date: 2009/01/31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef CREATE_MEMORY_OPERATION_CYBOL_NAME_SOURCE
#define CREATE_MEMORY_OPERATION_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../../constant/model/memory/integer_memory_model.c"

/** The name create memory operation cybol name. */
static wchar_t NAME_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY[] = {L'n', L'a', L'm', L'e'};
static wchar_t* NAME_CREATE_MEMORY_OPERATION_CYBOL_NAME = NAME_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY;
static int* NAME_CREATE_MEMORY_OPERATION_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_MEMORY_MODEL_ARRAY;

/** The abstraction create memory operation cybol name. */
static wchar_t ABSTRACTION_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'b', L's', L't', L'r', L'a', L'c', L't', L'i', L'o', L'n'};
static wchar_t* ABSTRACTION_CREATE_MEMORY_OPERATION_CYBOL_NAME = ABSTRACTION_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY;
static int* ABSTRACTION_CREATE_MEMORY_OPERATION_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_MEMORY_MODEL_ARRAY;

/** The element create memory operation cybol name. */
static wchar_t ELEMENT_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY[] = {L'e', L'l', L'e', L'm', L'e', L'n', L't'};
static wchar_t* ELEMENT_CREATE_MEMORY_OPERATION_CYBOL_NAME = ELEMENT_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY;
static int* ELEMENT_CREATE_MEMORY_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_MEMORY_MODEL_ARRAY;

/** The whole create memory operation cybol name. */
static wchar_t WHOLE_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY[] = {L'w', L'h', L'o', L'l', L'e'};
static wchar_t* WHOLE_CREATE_MEMORY_OPERATION_CYBOL_NAME = WHOLE_CREATE_MEMORY_OPERATION_CYBOL_NAME_ARRAY;
static int* WHOLE_CREATE_MEMORY_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/* CREATE_MEMORY_OPERATION_CYBOL_NAME_SOURCE */
#endif
