/*
 * Copyright (C) 1999-2009. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: list_file_operation_cybol_name.c,v $ $Revision: 1.2 $ $Date: 2009/01/31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef LIST_FILE_OPERATION_CYBOL_NAME_SOURCE
#define LIST_FILE_OPERATION_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../../constant/model/memory/integer_memory_model.c"

/** The all list directory contents file operation cybol name. */
static wchar_t ALL_LIST_FILE_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'l', L'l'};
static wchar_t* ALL_LIST_FILE_OPERATION_CYBOL_NAME = ALL_LIST_FILE_OPERATION_CYBOL_NAME_ARRAY;
static int* ALL_LIST_FILE_OPERATION_CYBOL_NAME_COUNT = NUMBER_3_INTEGER_MEMORY_MODEL_ARRAY;

/** The long listing list directory contents file operation cybol name. */
static wchar_t LONG_LISTING_LIST_FILE_OPERATION_CYBOL_NAME_ARRAY[] = {L'l', L'o', L'n', L'g', L'_', L'l', L'i', L's', L't', L'i', L'n', L'g'};
static wchar_t* LONG_LISTING_LIST_FILE_OPERATION_CYBOL_NAME = LONG_LISTING_LIST_FILE_OPERATION_CYBOL_NAME_ARRAY;
static int* LONG_LISTING_LIST_FILE_OPERATION_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_MEMORY_MODEL_ARRAY;

/* LIST_FILE_OPERATION_CYBOL_NAME_SOURCE */
#endif
