/*
 * Copyright (C) 1999-2009. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: operation_mode_cyboi_model.c,v $ $Revision: 1.3 $ $Date: 2009/01/31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef OPERATION_MODE_CYBOI_MODEL_SOURCE
#define OPERATION_MODE_CYBOI_MODEL_SOURCE

#include "../../../constant/model/memory/integer_memory_model.c"

/** The version operation mode cyboi model. */
static int* VERSION_OPERATION_MODE_CYBOI_MODEL = NUMBER_0_INTEGER_MEMORY_MODEL_ARRAY;

/** The help operation mode cyboi model. */
static int* HELP_OPERATION_MODE_CYBOI_MODEL = NUMBER_1_INTEGER_MEMORY_MODEL_ARRAY;

/** The test operation mode cyboi model. */
static int* TEST_OPERATION_MODE_CYBOI_MODEL = NUMBER_2_INTEGER_MEMORY_MODEL_ARRAY;

/** The knowledge operation mode cyboi model. */
static int* KNOWLEDGE_OPERATION_MODE_CYBOI_MODEL = NUMBER_3_INTEGER_MEMORY_MODEL_ARRAY;

/* OPERATION_MODE_CYBOI_MODEL_SOURCE */
#endif
