/*
 * Copyright (C) 1999-2023. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.27.0 2023-08-31
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef ARCHIVE_FILE_LOGIC_CYBOL_NAME_CONSTANT_HEADER
#define ARCHIVE_FILE_LOGIC_CYBOL_NAME_CONSTANT_HEADER

//
// System interface
//

#include <stddef.h> // wchar_t

//
// Library interface
//

#include "constant.h"

/** The bzip2 archive file logic cybol name. */
static wchar_t* BZIP2_ARCHIVE_FILE_LOGIC_CYBOL_NAME = L"bzip2";
static int* BZIP2_ARCHIVE_FILE_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The create archive file logic cybol name. */
static wchar_t* CREATE_ARCHIVE_FILE_LOGIC_CYBOL_NAME = L"create";
static int* CREATE_ARCHIVE_FILE_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The update archive file logic cybol name. */
static wchar_t* UPDATE_ARCHIVE_FILE_LOGIC_CYBOL_NAME = L"update";
static int* UPDATE_ARCHIVE_FILE_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* ARCHIVE_FILE_LOGIC_CYBOL_NAME_CONSTANT_HEADER */
#endif
