/*
 * Copyright (C) 1999-2023. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.26.0 2023-04-04
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef DELIMITER_CSV_NAME_CONSTANT_HEADER
#define DELIMITER_CSV_NAME_CONSTANT_HEADER

//
// System interface
//

#include <stddef.h> // wchar_t

//
// Library interface
//

#include "constant.h"

/** The colon delimiter csv name. */
static wchar_t* COLON_DELIMITER_CSV_NAME = COLON_UNICODE_CHARACTER_CODE_MODEL_ARRAY;
static int* COLON_DELIMITER_CSV_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The comma delimiter csv name. */
static wchar_t* COMMA_DELIMITER_CSV_NAME = COMMA_UNICODE_CHARACTER_CODE_MODEL_ARRAY;
static int* COMMA_DELIMITER_CSV_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The semicolon delimiter csv name. */
static wchar_t* SEMICOLON_DELIMITER_CSV_NAME = SEMICOLON_UNICODE_CHARACTER_CODE_MODEL_ARRAY;
static int* SEMICOLON_DELIMITER_CSV_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The space delimiter csv name. */
static wchar_t* SPACE_DELIMITER_CSV_NAME = SPACE_UNICODE_CHARACTER_CODE_MODEL_ARRAY;
static int* SPACE_DELIMITER_CSV_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The tabulation delimiter csv name. */
static wchar_t* TABULATION_DELIMITER_CSV_NAME = CHARACTER_TABULATION_UNICODE_CHARACTER_CODE_MODEL_ARRAY;
static int* TABULATION_DELIMITER_CSV_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* DELIMITER_CSV_NAME_CONSTANT_HEADER */
#endif
