/*
 * Copyright (C) 1999-2022. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.24.0 2022-12-24
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef ELEMENT_STATE_CYBOL_FORMAT_CONSTANT_SOURCE
#define ELEMENT_STATE_CYBOL_FORMAT_CONSTANT_SOURCE

#include <stddef.h> // wchar_t

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// Element (in a knowledge tree accessed at runtime)
//
// IANA media type: not defined
// Self-defined media type: element
// This media type is a CYBOL extension.
//

/**
 * The element/part state cybol format.
 *
 * Description:
 *
 * A PART node of the cyboi-internal knowledge tree.
 *
 * Each tree node (also called part) has a DOUBLE hierarchy representing:
 * - model hierarchy: whole-part, container-element, macrocosm-microcosm, child parts
 * - properties hierarchy: metadata, constraints, for example parametres of a function or the size of a graphical window
 *
 * Examples:
 *
 * <node name="empty_part_to_be_created" channel="inline" format="element/part" model=""/>
 * <node name="part_read_from_file" channel="file" format="element/part" model="path/to/file.cybol"/>
 */
static wchar_t* PART_ELEMENT_STATE_CYBOL_FORMAT = L"element/part";
static int* PART_ELEMENT_STATE_CYBOL_FORMAT_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The element/property state cybol format.
 *
 * Description:
 *
 * A PROPERTY node of the cyboi-internal knowledge tree.
 *
 * Each tree node (also called part) has a DOUBLE hierarchy representing:
 * - model hierarchy: whole-part, container-element, macrocosm-microcosm, child parts
 * - properties hierarchy: metadata, constraints, for example parametres of a function or the size of a graphical window
 *
 * Examples:
 *
 * <node name="empty_property_to_be_created" channel="inline" format="element/property" model=""/>
 * <node name="property_read_from_file" channel="file" format="element/property" model="path/to/file.cybol"/>
 */
static wchar_t* PROPERTY_ELEMENT_STATE_CYBOL_FORMAT = L"element/property";
static int* PROPERTY_ELEMENT_STATE_CYBOL_FORMAT_COUNT = NUMBER_16_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* ELEMENT_STATE_CYBOL_FORMAT_CONSTANT_SOURCE */
#endif
