/*
 * Copyright (C) 1999-2018. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.20.0 2018-06-30
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef KEY_PROCESS_WIN32_CONSOLE_READER_SOURCE
#define KEY_PROCESS_WIN32_CONSOLE_READER_SOURCE

#include <windows.h>

#include "../../../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../../../constant/model/cyboi/state/boolean_state_cyboi_model.c"
#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"
#include "../../../../constant/model/cyboi/state/pointer_state_cyboi_model.c"
#include "../../../../constant/name/cyboi/state/internal_memory_state_cyboi_name.c"
#include "../../../../logger/logger.c"

/**
 * Processes a win32 console key event.
 *
 * @param p0 the internal memory data
 * @param p1 the event record
 * @param p2 the event type
 */
void read_win32_console_process_key(void* p0, void* p1, void* p2) {

    // The mouse button or keycode of the physical key on the keyboard.
    // Possible types are: xcb_button_t, uint8_t, xcb_keycode_t
    int bk = *NUMBER_0_INTEGER_STATE_CYBOI_MODEL;
    // The button- or key mask.
    int m = *NUMBER_0_INTEGER_STATE_CYBOI_MODEL;

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Read win32 console process key.");

    // Get event record.
//    KEY_EVENT_RECORD r = (*id).Event.KeyEvent;

    // Get flag if key is pressed
    // (true - pressed; false - released).
    //?? BOOL b = (int) r.bKeyDown;

    // Get repeat count, which indicates
    // that a key is being held down.
    //?? WORD rc = (int) r.wRepeatCount;

    // Get virtual key code that identifies
    // the given key in a device-INDEPENDENT manner.
//    *bk = (int) r.wVirtualKeyCode;

    // Get virtual scan code of the given key
    // that represents the device-DEPENDENT value
    // generated by the keyboard hardware.
    //?? WORD sc = (int) r.wVirtualScanCode;

    // Get translated unicode character.
    //?? WCHAR wc = (wchar_t) r.uChar.UnicodeChar;

    // Get control key state (button or key mask).
//    *m = (int) r.dwControlKeyState;
}

/* KEY_PROCESS_WIN32_CONSOLE_READER_SOURCE */
#endif
