/*
 * Copyright (C) 1999-2017. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.19.0 2017-04-10
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef SEND_COMMUNICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define SEND_COMMUNICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// Properties.
//

/** The area send communication logic cybol name. */
static wchar_t* AREA_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"area";
static int* AREA_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The channel send communication logic cybol name. */
static wchar_t* CHANNEL_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"channel";
static int* CHANNEL_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The clear send communication logic cybol name. */
static wchar_t* CLEAR_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"clear";
static int* CLEAR_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The encoding send communication logic cybol name. */
static wchar_t* ENCODING_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"encoding";
static int* ENCODING_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The format send communication logic cybol name. */
static wchar_t* FORMAT_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"format";
static int* FORMAT_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The language send communication logic cybol name. */
static wchar_t* LANGUAGE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"language";
static int* LANGUAGE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The message send communication logic cybol name. */
static wchar_t* MESSAGE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"message";
static int* MESSAGE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The metadata send communication logic cybol name. */
static wchar_t* METADATA_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"metadata";
static int* METADATA_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The newline send communication logic cybol name. */
static wchar_t* NEWLINE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"newline";
static int* NEWLINE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The null-termination send communication logic cybol name. */
static wchar_t* NULL_TERMINATION_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"null-termination";
static int* NULL_TERMINATION_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_16_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The receiver send communication logic cybol name. */
static wchar_t* RECEIVER_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"receiver";
static int* RECEIVER_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The sender send communication logic cybol name. */
static wchar_t* SENDER_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"sender";
static int* SENDER_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Constraints.
//

/** The indentation language send communication logic cybol name. */
static wchar_t* INDENTATION_LANGUAGE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME = L"indentation";
static int* INDENTATION_LANGUAGE_SEND_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* SEND_COMMUNICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
