/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TEXT_GUI_SERIALISER_SOURCE
#define TEXT_GUI_SERIALISER_SOURCE

#include "../../../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../../../constant/model/cyboi/log/message_log_cyboi_model.c"
#include "../../../../logger/logger.c"

#ifdef __APPLE__
    //?? Add support for Cocoa
#elif WIN32
    #include "../../../../executor/representer/serialiser/win32_display/text_win32_display_serialiser.c"
#elif GNU_LINUX_OPERATING_SYSTEM
    #include "../../../../executor/representer/serialiser/x_window_system/text_x_window_system_serialiser.c"
#else
    #include "../../../../executor/representer/serialiser/x_window_system/text_x_window_system_serialiser.c"
#endif

/**
 * Serialises the gui text.
 *
 * @param p0 the connexion
 * @param p1 the screen
 * @param p2 the window
 * @param p3 the graphic context
 * @param p4 the win32 device context
 * @param p5 the source model data
 * @param p6 the source model count
 * @param p7 the position x
 * @param p8 the position y
 * @param p9 the size width
 * @param p10 the size height
 */
void serialise_gui_text(void* p0, void* p1, void* p2, void* p3, void* p4, void* p5, void* p6, void* p7, void* p8, void* p9, void* p10) {

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Serialise gui text.");

#ifdef __APPLE__
    //?? Add support for Cocoa
#elif WIN32
    serialise_win32_display_text(p4, p5, p6, p7, p8, p9, p10);
#elif GNU_LINUX_OPERATING_SYSTEM
    serialise_x_window_system_text(p0, p1, p2, p3, p5, p6, p7, p8, p9, p10);
#else
    serialise_x_window_system_text(p0, p1, p2, p3, p5, p6, p7, p8, p9, p10);
#endif
}

/* TEXT_GUI_SERIALISER_SOURCE */
#endif
