/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination copy file logic cybol name. */
static wchar_t DESTINATION_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME = DESTINATION_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* DESTINATION_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The force copy file logic cybol name. */
static wchar_t FORCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'c', L'e'};
static wchar_t* FORCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME = FORCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* FORCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The gzip copy file logic cybol name. */
static wchar_t GZIP_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'g', L'z', L'i', L'p'};
static wchar_t* GZIP_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME = GZIP_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* GZIP_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source copy file logic cybol name. */
static wchar_t SOURCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME = SOURCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* SOURCE_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The unpack copy file logic cybol name. */
static wchar_t UNPACK_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'u', L'n', L'p', L'a', L'c', L'k'};
static wchar_t* UNPACK_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME = UNPACK_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* UNPACK_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The verbal copy file logic cybol name. */
static wchar_t VERBAL_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'v', L'e', L'r', L'b', L'a', L'l'};
static wchar_t* VERBAL_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME = VERBAL_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* VERBAL_TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* TAPE_ARCHIVER_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif