/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The force parameter for the remove logic in cybol. */
static wchar_t FORCE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'c', L'e'};
static wchar_t* FORCE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = FORCE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* FORCE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The path parameter for the remove logic in cybol. */
static wchar_t PATH_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', L'h'};
static wchar_t* PATH_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = PATH_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PATH_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The interactive parameter for the remove logic in cybol. */
static wchar_t INTERACTIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L't', L'e', L'r', L'a', L'c', L't', L'i', L'v', L'e'};
static wchar_t* INTERACTIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = INTERACTIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* INTERACTIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The recursive parameter for the remove logic in cybol. */
static wchar_t RECURSIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'e', L'c', L'u', L'r', L's', L'i', L'v', L'e'};
static wchar_t* RECURSIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = RECURSIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* RECURSIVE_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The verbal parameter for the remove logic in cybol. */
static wchar_t VERBAL_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'v', L'e', L'r', L'b', L'a', L'l'};
static wchar_t* VERBAL_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = VERBAL_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* VERBAL_REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* REMOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
