/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/**
* The routingtable Netstat logic cybol name.
*
*/
static wchar_t ROUTINGTABLE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'o', L'u',L't', L'i', L'n', L'g',L't', L'a', L'b', L'l', L'e'};
static wchar_t* ROUTINGTABLE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = ROUTINGTABLE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* ROUTINGTABLE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The interface Netstat cybol name.
*
*/
static wchar_t INTERFACE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L't',L'e', L'r', L'f', L'a',L'c', L'e'};
static wchar_t* INTERFACE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = INTERFACE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* INTERFACE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The groups Netstat logic cybol name.
*
*/
static wchar_t GROUPS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'g', L'r', L'o',L'u', L'p', L's'};
static wchar_t* GROUPS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = GROUPS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* GROUPS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The statistics Netstat logic cybol name.
*
*/
static wchar_t STATISTICS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L't', L'a',L't', L'i', L's', L't',L'i', L'c', L's'};
static wchar_t* STATISTICS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = STATISTICS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* STATISTICS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The masquerade Netstat logic cybol name.
*
*/
static wchar_t MASQUERADE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'a', L's',L'q', L'u', L'e', L'r',L'a', L'd', L'e'};
static wchar_t* MASQUERADE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = MASQUERADE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* MASQUERADE_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The long Netstat logic cybol name.
*
*/
static wchar_t LONG_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'o', L'n',L'g'};
static wchar_t* LONG_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = LONG_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LONG_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The nohostname Netstat logic cybol name.
*
*/
static wchar_t NOHOST_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'n', L'o', L'h',L'o', L's', L't'};
static wchar_t* NOHOST_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = NOHOST_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* NOHOST_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The extended Netstat logic cybol name.
*
*/
static wchar_t EXTENDED_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'e', L'x', L't',L'e', L'n', L'd', L'e',L'd'};
static wchar_t* EXTENDED_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = EXTENDED_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* EXTENDED_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The programnames Netstat logic cybol name.
*
*/
static wchar_t PROGNAMES_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'o',L'g', L'n', L'a', L'm',L'e', L's'};
static wchar_t* PROGNAMES_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = PROGNAMES_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PROGNAMES_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The listening sockets Netstat logic cybol name.
*
*/
static wchar_t LISTENSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'i', L's',L't', L'e', L'n', L's',L'o', L'c', L'k', L'e', L't', L's'};
static wchar_t* LISTENSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = LISTENSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LISTENSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_13_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The all sockets Netstat logic cybol name.
*
*/
static wchar_t ALLSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'a', L'l', L'l',L's', L'o', L'c', L'k',L'e', L't', L's'};
static wchar_t* ALLSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = ALLSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* ALLSOCKETS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The timers Netstat logic cybol name.
*
*/
static wchar_t TIMERS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'i', L'm',L'e', L'r', L's'};
static wchar_t* TIMERS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = TIMERS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* TIMERS_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
* The active connection Netstat logic cybol name.
*
*/
static wchar_t ACTIVECONN_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'a', L'c', L't',L'i', L'v', L'e', L'c' ,L'o', L'n', L'n'};
static wchar_t* ACTIVECONN_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME = ACTIVECONN_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* ACTIVECONN_NETSTAT_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;



/* USERLOG_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif

