/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The all option for the disk free logic in cybol. */
static wchar_t ALL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'a', L'l', L'l'};
static wchar_t* ALL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME = ALL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* ALL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The human-readable option for the disk free logic in cybol. */
static wchar_t HUMAN_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'h', L'u', L'm', L'a', L'n'};
static wchar_t* HUMAN_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME = HUMAN_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* HUMAN_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The kilobytes option for the disk free logic in cybol. */
static wchar_t KILOBYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'k', L'i', L'l', L'o', L'b', L'y', L't', L'e', L's'};
static wchar_t* KILOBYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME = KILOBYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* KILOBYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The local filesystem only option for the disk free logic in cybol. */
static wchar_t LOCAL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'o', L'c', L'a', L'l'};
static wchar_t* LOCAL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME = LOCAL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LOCAL_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The megabytes option for the disk free logic in cybol. */
static wchar_t MEGABYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'e', L'g', L'a', L'b', L'y', L't', L'e', L's'};
static wchar_t* MEGABYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME = MEGABYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* MEGABYTES_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The print type option for the disk free logic in cybol. */
static wchar_t TYPE_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME = TYPE_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* TYPE_DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* DISK_FREE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
