/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef COPY_FILE_COMMANDER_OPTION_NAME_CONSTANT_SOURCE
#define COPY_FILE_COMMANDER_OPTION_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination copy file logic cybol name. */
static wchar_t DESTINATION_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = DESTINATION_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* DESTINATION_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The force copy file logic cybol name. */
static wchar_t FORCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'c', L'e'};
static wchar_t* FORCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = FORCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* FORCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The interactive copy file logic cybol name. */
static wchar_t INTERACTIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L't', L'e', L'r', L'a', L'c', L't', L'i', L'v', L'e'};
static wchar_t* INTERACTIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = INTERACTIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* INTERACTIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The preserver all attributes copy file logic cybol name. */
static wchar_t PRESERVE_ALL_ATTRIBUTES_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'e', L's', L'e', L'r', L'v', L'e', L'-', L'a', L'l', L'l', L'-', L'a', L't', L't', L'r', L'i', L'b', L'u', L't', L'e', L's'};
static wchar_t* PRESERVE_ALL_ATTRIBUTES_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = PRESERVE_ALL_ATTRIBUTES_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PRESERVE_ALL_ATTRIBUTES_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_23_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The preserver links copy file logic cybol name. */
static wchar_t PRESERVE_LINKS_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'e', L's', L'e', L'r', L'v', L'e', L'-', L'l', L'i', L'n', L'k', L's'};
static wchar_t* PRESERVE_LINKS_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = PRESERVE_LINKS_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PRESERVE_LINKS_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_14_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The recursive copy file logic cybol name. */
static wchar_t RECURSIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'e', L'c', L'u', L'r', L's', L'i', L'v', L'e'};
static wchar_t* RECURSIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = RECURSIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* RECURSIVE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source copy file logic cybol name. */
static wchar_t SOURCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = SOURCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* SOURCE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The update copy file logic cybol name. */
static wchar_t UPDATE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'u', L'p', L'd', L'a', L't', L'e'};
static wchar_t* UPDATE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = UPDATE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* UPDATE_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The verbal copy file logic cybol name. */
static wchar_t VERBAL_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'v', L'e', L'r', L'b', L'a', L'l'};
static wchar_t* VERBAL_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME = VERBAL_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* VERBAL_COPY_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* COPY_FILE_COMMANDER_OPTION_NAME_CONSTANT_SOURCE */
#endif
