/*
 * Copyright (C) 1999-2015. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.17.0 2015-04-20
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef STYLE_SOCKET_SYMBOLIC_NAME_GLOBALISER_SOURCE
#define STYLE_SOCKET_SYMBOLIC_NAME_GLOBALISER_SOURCE

#ifdef __APPLE__
    #include <sys/socket.h>
#elif WIN32
    #include <winsock.h>
#elif GNU_LINUX_OPERATING_SYSTEM
    #include <sys/socket.h>
#else
    #include <sys/socket.h>
#endif

#include "../../../variable/symbolic_name/style_socket_symbolic_name.c"

//
// The well-defined ip protocols below were mostly taken from:
//
// /usr/src/linux-headers-*-common/include/linux/net.h
// http://msdn.microsoft.com/en-us/library/windows/desktop/ms740506%28v=vs.85%29.aspx
//

/**
 * Initialises protocol socket symbolic name
 * (pre-processor-defined) global variables.
 */
void globalise_symbolic_name_socket_style() {

#ifdef __APPLE__
    *STREAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_STREAM; // 1 SOCK_STREAM
    *DATAGRAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DGRAM; // 2 SOCK_DGRAM
    *RAW_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RAW; // 3 SOCK_RAW
    *RDM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RDM; // 4 SOCK_RDM
    *SEQPACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_SEQPACKET; // 5 SOCK_SEQPACKET
    *DCCP_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DCCP; // 6 SOCK_DCCP
    *PACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_PACKET; // 10 SOCK_PACKET
#elif WIN32
    *STREAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_STREAM; // 1 SOCK_STREAM
    *DATAGRAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DGRAM; // 2 SOCK_DGRAM
    *RAW_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RAW; // 3 SOCK_RAW
    *RDM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RDM; // 4 SOCK_RDM
    *SEQPACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_SEQPACKET; // 5 SOCK_SEQPACKET
//??    *DCCP_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DCCP; // 6 SOCK_DCCP
//??    *PACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_PACKET; // 10 SOCK_PACKET
#elif GNU_LINUX_OPERATING_SYSTEM
    *STREAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_STREAM; // 1 SOCK_STREAM
    *DATAGRAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DGRAM; // 2 SOCK_DGRAM
    *RAW_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RAW; // 3 SOCK_RAW
    *RDM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RDM; // 4 SOCK_RDM
    *SEQPACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_SEQPACKET; // 5 SOCK_SEQPACKET
    *DCCP_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DCCP; // 6 SOCK_DCCP
    *PACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_PACKET; // 10 SOCK_PACKET
#else
    *STREAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_STREAM; // 1 SOCK_STREAM
    *DATAGRAM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DGRAM; // 2 SOCK_DGRAM
    *RAW_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RAW; // 3 SOCK_RAW
    *RDM_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_RDM; // 4 SOCK_RDM
    *SEQPACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_SEQPACKET; // 5 SOCK_SEQPACKET
    *DCCP_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_DCCP; // 6 SOCK_DCCP
    *PACKET_STYLE_SOCKET_SYMBOLIC_NAME = SOCK_PACKET; // 10 SOCK_PACKET
#endif
}

/* STYLE_SOCKET_SYMBOLIC_NAME_GLOBALISER_SOURCE */
#endif
