 /*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TESTER_EXECUTOR_SOURCE
#define TESTER_EXECUTOR_SOURCE
#include "memoriser/memoriser_tester.c"
#include "manipulator/manipulator_tester.c"
#include "calculator/calculator_tester.c"
#include "caster/caster_tester.c"
#include "comparator/comparator_tester.c"
#include "runner/sleeper_tester.c"
#include "searcher/searcher_tester.c"
#include "representer/representer_tester.c"
#include "communicator/communicator_tester.c"
#include "accessor/accessor_tester.c"

// TODO: Reinclude serial_port_tester.c / Enable Serial Communication in Win32
// (Don't forget to enable related statements below.)
#ifndef _MSC_VER
//?? #include "communicator/serial_port_tester.c"
#endif

#include "converter/converter_tester.c"
#include "modifier/modifier_tester.c"
#include "commander/commander_tester.c"
//
// Examples for source code testing via log messages.
//
// fwprintf(stdout, L"TEST integer: %i\n", x);
// fwprintf(stdout, L"TEST pointer: %i\n", x);
// fwprintf(stdout, L"TEST w_char array string: %ls\n", (wchar_t*) x);
// fwprintf(stdout, L"TEST string literal: %ls\n", "string");
//

//
// Using printf to check parametre values:
//
// The printf function uses stdout for output, but nothing appears on console.
// Therefore, fprintf is used and stdout is given for output.
// Example:
// int x = *NUMBER_2_INTEGER_STATE_CYBOI_MODEL;
// fwprintf(stdout, L"The value of x is: %d\n", x);
//

/**
 * The main test procedure.
 *
 * @param p0 the test unit
 */

void test_executor(void* p0) {
    log_message_terminated((void*) INFORMATION_LEVEL_LOG_CYBOI_MODEL, (void*) L"Test.");

        int r = *FALSE_BOOLEAN_STATE_CYBOI_MODEL;

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_UNIT_TEST_CYBOI_MODEL);

            if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL)
            {
                compare_integer_equal((void*)&r, p0, (void*)ALL_UNIT_TEST_CYBOI_MODEL );
            }

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // all tests
                test_accessor();
                test_memoriser();
                test_manipulator();
                test_calculator();
                test_caster();
                test_comparator();
                test_commander();
                test_communicator();
                test_representer();
                test_sleeper();
                test_searcher();

#ifndef _MSC_VER
//??                test_serial_port();
#endif

                //special test case, which couldn't match any folder

            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_ACCESSOR_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // accessor tests
                test_accessor();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_CALCULATOR_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // calculator tests
                test_calculator();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_CASTER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // caster tests
                test_caster();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_COMMANDER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // commandander tests
                test_commander();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_COMMUNICATOR_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // communicator tests
                test_communicator();
#ifndef _MSC_VER
//??                test_serial_port();
#endif
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_COMPARATOR_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // comparator tests
                test_comparator();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_CONVERTER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // converter tests
                test_converter();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_LIFEGUARD_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // lifeguard tests
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_LOGIFIER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // logifier tests
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_MAINTAINER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // maintainer tests
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_MANIPULATOR_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // manipulator tests
                test_manipulator();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_MEMORISER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // memoriser tests
                test_memoriser();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_MODIFIER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // modifier tests
                test_modifier();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_REFERENCER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // referencer tests
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_REPRESENTER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // representer tests
                test_representer();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_RUNNER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // runner tests
                test_sleeper();
            }
        }

        if (r == *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

            compare_integer_equal((void*) &r, p0, (void*) EXECUTOR_SEARCHER_UNIT_TEST_CYBOI_MODEL);

            if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

                // searcher tests
                test_searcher();
            }
        }
}
/* TESTER_EXECUTOR_SOURCE */
#endif

