/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/**
 * The path for the change permission file logic cybol name.
 *
 * It indicates the path of a directory or file for change permission
 */
static wchar_t PATH_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', 'h'};
static wchar_t* PATH_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = PATH_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PATH_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The recursive change permission file logic cybol name.
 *
 * It indicates that the permissions are recursively applied to folders and files
 */
static wchar_t RECURSIVE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'e', L'c', L'u', L'r', L's', L'i', L'v', L'e'};
static wchar_t* RECURSIVE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = RECURSIVE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* RECURSIVE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The silent change permission file logic cybol name.
 *
 * It indicates that the most error messages will suppressed
 */
static wchar_t SILENT_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'i', L'l', L'e', L'n', L't'};
static wchar_t* SILENT_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = SILENT_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* SILENT_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The verbose change permission file logic cybol name.
 *
 * It output a diagnostic for every file processed
 */
static wchar_t VERBOSE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'v', L'e', L'r', L'b', L'o', L's', L'e'};
static wchar_t* VERBOSE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = VERBOSE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* VERBOSE_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The user change permission file logic cybol name.
 *
 * It indicates the user permissions, for example 'rwx'
 */
static wchar_t USER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'u', L's', L'e', L'r'};
static wchar_t* USER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = USER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* USER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The group change permission file logic cybol name.
 *
 * It indicates the group permissions, for example 'rwx'
 */
static wchar_t GROUP_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'g', L'r', L'o', L'u', L'p'};
static wchar_t* GROUP_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = GROUP_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* GROUP_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The other change permission file logic cybol name.
 *
 * It indicates the other permissions, for example 'rwx'
 */
static wchar_t OTHER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'o', L't', L'h', L'e', L'r'};
static wchar_t* OTHER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME = OTHER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* OTHER_CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* CHANGE_PERMISSION_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
