/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_CONSTANT_SOURCE
#define COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The force copy file command option name. */
static wchar_t FORCE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'f'};
static wchar_t* FORCE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = FORCE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* FORCE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The interactive copy file command option name. */
static wchar_t INTERACTIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'i'};
static wchar_t* INTERACTIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = INTERACTIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* INTERACTIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The preserve all attributes copy file command option name. */
static wchar_t PRESERVE_ALL_ATTRIBUTES_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'a'};
static wchar_t* PRESERVE_ALL_ATTRIBUTES_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = PRESERVE_ALL_ATTRIBUTES_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* PRESERVE_ALL_ATTRIBUTES_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The preserve links copy file command option name. */
static wchar_t PRESERVE_LINKS_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'd'};
static wchar_t* PRESERVE_LINKS_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = PRESERVE_LINKS_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* PRESERVE_LINKS_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The recursive copy file command option name. */
static wchar_t RECURSIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'r'};
static wchar_t* RECURSIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = RECURSIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* RECURSIVE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The update copy file command option name. */
static wchar_t UPDATE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'u'};
static wchar_t* UPDATE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = UPDATE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* UPDATE_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The verbal copy file command option name. */
static wchar_t VERBAL_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'v'};
static wchar_t* VERBAL_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME = VERBAL_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_ARRAY;
static int* VERBAL_COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* COPY_FILE_UNIX_COMMANDER_COMMAND_OPTION_NAME_CONSTANT_SOURCE */
#endif