/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_CONSTANT_SOURCE
#define CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The recursive change permission unix command option name. */
static wchar_t RECURSIVE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'-', L'r', L'e', L'c', L'u', L'r', L's', L'i', L'v', L'e'};
static wchar_t* RECURSIVE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME = RECURSIVE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_ARRAY;
static int* RECURSIVE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The silent change permission unix command option name. */
static wchar_t SILENT_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'-', L's', L'i', L'l', L'e', L'n', L't'};
static wchar_t* SILENT_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME = SILENT_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_ARRAY;
static int* SILENT_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The verbose change permission unix command option name. */
static wchar_t VERBOSE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_ARRAY[] = {L'-', L'-', L'v', L'e', L'r', L'b', L'o', L's', L'e'};
static wchar_t* VERBOSE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME = VERBOSE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_ARRAY;
static int* VERBOSE_CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* CHANGE_PERMISSION_UNIX_COMMAND_OPTION_NAME_CONSTANT_SOURCE */
#endif
