/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef EXTRA_INTEGER_STATE_CYBOI_MODEL_CONSTANT_SOURCE
#define EXTRA_INTEGER_STATE_CYBOI_MODEL_CONSTANT_SOURCE

//
// Numbers 10,000 - 99,999.
//

/** The number 10000 integer state cyboi model. */
static int NUMBER_10000_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {10000};
static int* NUMBER_10000_INTEGER_STATE_CYBOI_MODEL = NUMBER_10000_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 19200 integer state cyboi model. */
static int NUMBER_19200_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {19200};
static int* NUMBER_19200_INTEGER_STATE_CYBOI_MODEL = NUMBER_19200_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 38400 integer state cyboi model. */
static int NUMBER_38400_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {38400};
static int* NUMBER_38400_INTEGER_STATE_CYBOI_MODEL = NUMBER_38400_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 57600 integer state cyboi model. */
static int NUMBER_57600_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {57600};
static int* NUMBER_57600_INTEGER_STATE_CYBOI_MODEL = NUMBER_57600_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Numbers 100,000 - 999,999.
//

/** The number 115200 integer state cyboi model. */
static int NUMBER_115200_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {115200};
static int* NUMBER_115200_INTEGER_STATE_CYBOI_MODEL = NUMBER_115200_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 230400 integer state cyboi model. */
static int NUMBER_230400_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {230400};
static int* NUMBER_230400_INTEGER_STATE_CYBOI_MODEL = NUMBER_230400_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 460800 integer state cyboi model. */
static int NUMBER_460800_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {460800};
static int* NUMBER_460800_INTEGER_STATE_CYBOI_MODEL = NUMBER_460800_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 500000 integer state cyboi model. */
static int NUMBER_500000_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {500000};
static int* NUMBER_500000_INTEGER_STATE_CYBOI_MODEL = NUMBER_500000_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 576000 integer state cyboi model. */
static int NUMBER_576000_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {576000};
static int* NUMBER_576000_INTEGER_STATE_CYBOI_MODEL = NUMBER_576000_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The number 921600 integer state cyboi model. */
static int NUMBER_921600_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {921600};
static int* NUMBER_921600_INTEGER_STATE_CYBOI_MODEL = NUMBER_921600_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Numbers 1,000,000 - 9,999,999.
//

/** The number 1000000 integer state cyboi model. */
static int NUMBER_1000000_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {1000000};
static int* NUMBER_1000000_INTEGER_STATE_CYBOI_MODEL = NUMBER_1000000_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Numbers 10,000,000 - 99,999,999.
//

//
// Numbers 100,000,000 - 999,999,999.
//

/** The number 100000000 integer state cyboi model. */
static int NUMBER_100000000_INTEGER_STATE_CYBOI_MODEL_ARRAY[] = {100000000};
static int* NUMBER_100000000_INTEGER_STATE_CYBOI_MODEL = NUMBER_100000000_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Numbers 1,000,000,000 - 9,999,999,999.
//

/* EXTRA_INTEGER_STATE_CYBOI_MODEL_CONSTANT_SOURCE */
#endif
