/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef LIVE_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE
#define LIVE_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// The CYBOL type constants' names and values have been adapted to follow
// the style of the Internet media type / content type that is also
// known under the name Multipurpose Internet Mail Extensions (MIME).
// These types are managed by the Internet Assigned Numbers Authority (IANA).
// See document "Multipurpose Internet Mail Extensions (MIME) Part Two: Media Types":
// http://tools.ietf.org/html/rfc2046
//
// Since the MIME standard does not offer media types for certain data,
// CYBOL had to invent new languages (media types), e.g. for dates, numbers etc.
// This is not meant to pollute the MIME standard, just to fill a gap!
// In case IANA adopts these extensions one day -- fine.
// If, however, other media type values replacing ours are proposed,
// we are open to adapt the CYBOL language specification accordingly.
//

//
// Live (some operation to be processed over time).
//
// IANA media type: not defined
// Self-defined media type: live
// This media type is a CYBOL extension.
//

/**
 * The live/exit logic cybol format.
 *
 * Exit the cyboi system.
 *
 * This is a CYBOL extension.
 */
static wchar_t EXIT_LIVE_LOGIC_CYBOL_FORMAT_ARRAY[] = {L'l', L'i', L'v', L'e', L'/', L'e', L'x', L'i', L't'};
static wchar_t* EXIT_LIVE_LOGIC_CYBOL_FORMAT = EXIT_LIVE_LOGIC_CYBOL_FORMAT_ARRAY;
static int* EXIT_LIVE_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The live/interrupt logic cybol format.
 *
 * Interrupt a sensing operation.
 *
 * This is a CYBOL extension.
 */
static wchar_t INTERRUPT_LIVE_LOGIC_CYBOL_FORMAT_ARRAY[] = {L'l', L'i', L'v', L'e', L'/', L'i', L'n', L't', L'e', L'r', L'r', L'u', L'p', L't'};
static wchar_t* INTERRUPT_LIVE_LOGIC_CYBOL_FORMAT = INTERRUPT_LIVE_LOGIC_CYBOL_FORMAT_ARRAY;
static int* INTERRUPT_LIVE_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_14_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The live/sense logic cybol format.
 *
 * Wait for and sense input signals.
 *
 * This is a CYBOL extension.
 */
static wchar_t SENSE_LIVE_LOGIC_CYBOL_FORMAT_ARRAY[] = {L'l', L'i', L'v', L'e', L'/', L's', L'e', L'n', L's', L'e'};
static wchar_t* SENSE_LIVE_LOGIC_CYBOL_FORMAT = SENSE_LIVE_LOGIC_CYBOL_FORMAT_ARRAY;
static int* SENSE_LIVE_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* LIVE_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE */
#endif
