/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef RESPONSE_HEADER_HTTP_NAME_CONSTANT_SOURCE
#define RESPONSE_HEADER_HTTP_NAME_CONSTANT_SOURCE

#include <stddef.h>
#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// The following constants are taken from the HTTP 1.1 RFC 2616 specification:
// http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14
// They are sorted alphabetically here.
//

/** The Accept-Ranges response header http name. */
static unsigned char ACCEPT_RANGES_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'A', 'c', 'c', 'e', 'p', 't', '-', 'R', 'a', 'n', 'g', 'e', 's'};
static unsigned char* ACCEPT_RANGES_RESPONSE_HEADER_HTTP_NAME = ACCEPT_RANGES_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* ACCEPT_RANGES_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_13_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Age response header http name. */
static unsigned char AGE_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'A', 'g', 'e'};
static unsigned char* AGE_RESPONSE_HEADER_HTTP_NAME = AGE_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* AGE_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ETag response header http name. */
static unsigned char ETAG_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'E', 'T', 'a', 'g'};
static unsigned char* ETAG_RESPONSE_HEADER_HTTP_NAME = ETAG_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* ETAG_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Location response header http name. */
static unsigned char LOCATION_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'L', 'o', 'c', 'a', 't', 'i', 'o', 'n'};
static unsigned char* LOCATION_RESPONSE_HEADER_HTTP_NAME = LOCATION_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* LOCATION_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Proxy-Authenticate response header http name. */
static unsigned char PROXY_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'P', 'r', 'o', 'x', 'y', '-', 'A', 'u', 't', 'h', 'e', 'n', 't', 'i', 'c', 'a', 't', 'e'};
static unsigned char* PROXY_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME = PROXY_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* PROXY_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_18_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Retry-After response header http name. */
static unsigned char RETRY_AFTER_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'R', 'e', 't', 'r', 'y', '-', 'A', 'f', 't', 'e', 'r'};
static unsigned char* RETRY_AFTER_RESPONSE_HEADER_HTTP_NAME = RETRY_AFTER_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* RETRY_AFTER_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Server response header http name. */
static unsigned char SERVER_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'S', 'e', 'r', 'v', 'e', 'r'};
static unsigned char* SERVER_RESPONSE_HEADER_HTTP_NAME = SERVER_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* SERVER_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The WWW-Authenticate response header http name. */
static unsigned char WWW_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME_ARRAY[] = {'W', 'W', 'W', '-', 'A', 'u', 't', 'h', 'e', 'n', 't', 'i', 'c', 'a', 't', 'e'};
static unsigned char* WWW_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME = WWW_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME_ARRAY;
static int* WWW_AUTHENTICATE_RESPONSE_HEADER_HTTP_NAME_COUNT = NUMBER_16_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* RESPONSE_HEADER_HTTP_NAME_CONSTANT_SOURCE */
#endif
