/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef MANIPULATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define MANIPULATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The value manipulation logic cybol name. */
static wchar_t VALUE_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'v', L'a', L'l', L'u', L'e'};
static wchar_t* VALUE_MANIPULATION_LOGIC_CYBOL_NAME = VALUE_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY;
static int* VALUE_MANIPULATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The position manipulation logic cybol name. */
static wchar_t POSITION_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'o', L's', L'i', L't', L'i', L'o', L'n'};
static wchar_t* POSITION_MANIPULATION_LOGIC_CYBOL_NAME = POSITION_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY;
static int* POSITION_MANIPULATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type manipulation logic cybol name. */
static wchar_t TYPE_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_MANIPULATION_LOGIC_CYBOL_NAME = TYPE_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY;
static int* TYPE_MANIPULATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The count manipulation logic cybol name. */
static wchar_t COUNT_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'u', L'n', L't'};
static wchar_t* COUNT_MANIPULATION_LOGIC_CYBOL_NAME = COUNT_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY;
static int* COUNT_MANIPULATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The index manipulation logic cybol name. */
static wchar_t INDEX_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'd', L'e', L'x'};
static wchar_t* INDEX_MANIPULATION_LOGIC_CYBOL_NAME = INDEX_MANIPULATION_LOGIC_CYBOL_NAME_ARRAY;
static int* INDEX_MANIPULATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* MANIPULATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
