/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef RUN_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE
#define RUN_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// The CYBOL type constants' names and values have been adapted to follow
// the style of the Internet media type / content type that is also
// known under the name Multipurpose Internet Mail Extensions (MIME).
// These types are managed by the Internet Assigned Numbers Authority (IANA).
// See document "Multipurpose Internet Mail Extensions (MIME) Part Two: Media Types":
// http://tools.ietf.org/html/rfc2046
//
// Since the MIME standard does not offer media types for certain data,
// CYBOL had to invent new languages (media types), e.g. for dates, numbers etc.
// This is not meant to pollute the MIME standard, just to fill a gap!
// In case IANA adopts these extensions one day -- fine.
// If, however, other media type values replacing ours are proposed,
// we are open to adapt the CYBOL language specification accordingly.
//

//
// Run (some operation to be processed over time).
//
// IANA media type: not defined
// Self-defined media type: run
// This media type is a CYBOL extension.
//

/**
 * The run/run logic cybol format.
 *
 * Run the given programme.
 *
 * This is a CYBOL extension.
 */
static wchar_t RUN_LOGIC_CYBOL_FORMAT_ARRAY[] = {L'r', L'u', L'n', L'/', L'r', L'u', L'n'};
static wchar_t* RUN_LOGIC_CYBOL_FORMAT = RUN_LOGIC_CYBOL_FORMAT_ARRAY;
static int* RUN_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The run/sleep-nano logic cybol format.
 *
 * Suspends execution of the calling thread for nanoseconds.
 * May be lengthened slightly by any system activity
 * or by the time spent processing the call
 * or by the granularity of system timers.
 *
 * This is a CYBOL extension.
 */
static wchar_t NANO_SLEEP_RUN_LOGIC_CYBOL_FORMAT_ARRAY[] = {L'r', L'u', L'n', L'/', L's', L'l', L'e', L'e', L'p', L'-', L'n', L'a', L'n', L'o'};
static wchar_t* NANO_SLEEP_RUN_LOGIC_CYBOL_FORMAT = NANO_SLEEP_RUN_LOGIC_CYBOL_FORMAT_ARRAY;
static int* NANO_SLEEP_RUN_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_14_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The run/sleep-second logic cybol format.
 *
 * Suspends execution of the calling thread for seconds.
 * May be lengthened slightly by any system activity
 * or by the time spent processing the call
 * or by the granularity of system timers.
 *
 * This is a CYBOL extension.
 */
static wchar_t SECOND_SLEEP_RUN_LOGIC_CYBOL_FORMAT_ARRAY[] = {L'r', L'u', L'n', L'/', L's', L'l', L'e', L'e', L'p', L'-', L's', L'e', L'c', L'o', L'n', L'd'};
static wchar_t* SECOND_SLEEP_RUN_LOGIC_CYBOL_FORMAT = SECOND_SLEEP_RUN_LOGIC_CYBOL_FORMAT_ARRAY;
static int* SECOND_SLEEP_RUN_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_16_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* RUN_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE */
#endif
