/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef ITEM_APPENDER_SOURCE
#define ITEM_APPENDER_SOURCE

#include <stdlib.h>
#include <string.h>

#include "../../../constant/type/cyboi/state_cyboi_type.c"
#include "../../../constant/model/cyboi/log/message_log_cyboi_model.c"
#include "../../../constant/model/cyboi/state/integer_state_cyboi_model.c"
#include "../../../constant/model/cyboi/state/pointer_state_cyboi_model.c"
#include "../../../constant/name/cyboi/state/item_state_cyboi_name.c"
#include "../../../executor/modifier/overwriter/item_overwriter.c"
#include "../../../logger/logger.c"

/**
 * Appends the source array to the destination item element
 * given by the destination item element index.
 *
 * A destination index is not expected as parametre,
 * since the source is appended at the end.
 *
 * The destination item element index is expected to be "data".
 * It has no sense to append "count" or "size",
 * since these are just integer primitives.
 * Thus, a destination item element index is not expected as parametre.
 *
 * @param p0 the destination item
 * @param p1 the source array
 * @param p2 the type
 * @param p3 the count
 * @param p4 the source array index
 */
void append_item_element(void* p0, void* p1, void* p2, void* p3, void* p4) {

    log_message_terminated((void*) INFORMATION_LEVEL_LOG_CYBOI_MODEL, (void*) L"Append item element.");

    // The destination item element count.
    void* c = *NULL_POINTER_STATE_CYBOI_MODEL;

    // Get destination item element count.
    copy_array_forward((void*) &c, p0, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) COUNT_ITEM_STATE_CYBOI_NAME);

    // Append source- to destination item data array.
    // CAUTION! Use destination item count as destination index.
    // CAUTION! Set adjust count flag, since destination gets extended by append.
    overwrite_item_element(p0, p1, p2, p3, c, p4, (void*) TRUE_BOOLEAN_STATE_CYBOI_MODEL, (void*) DATA_ITEM_STATE_CYBOI_NAME);
}

/**
 * Overwrites the destination- with the source item.
 *
 * A destination index is not expected as parametre,
 * since the source is appended at the end.
 *
 * @param p0 the destination item
 * @param p1 the source item
 * @param p2 the type
 * @param p3 the count
 * @param p4 the source index
 */
void append_item(void* p0, void* p1, void* p2, void* p3, void* p4) {

    log_message_terminated((void*) INFORMATION_LEVEL_LOG_CYBOI_MODEL, (void*) L"Append item.");

    // The destination item count.
    void* dc = *NULL_POINTER_STATE_CYBOI_MODEL;

    // Get destination item count.
    copy_array_forward((void*) &dc, p0, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) COUNT_ITEM_STATE_CYBOI_NAME);

    // Append source- to destination item data array.
    // CAUTION! Use destination item count as destination index.
    // CAUTION! Set adjust count flag, since destination gets extended by append.
    overwrite_item(p0, p1, p2, p3, dc, p4, (void*) TRUE_BOOLEAN_STATE_CYBOI_MODEL);
}

/* ITEM_APPENDER_SOURCE */
#endif
