/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The force parameter for the move logic in cybol. */
static wchar_t FORCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'c', L'e'};
static wchar_t* FORCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = FORCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* FORCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source path parameter for the move logic in cybol. */
static wchar_t SOURCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = SOURCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* SOURCE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The destination path parameter for the move logic in cybol. */
static wchar_t DESTINATION_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = DESTINATION_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* DESTINATION_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The interactive parameter for the move logic in cybol. */
static wchar_t INTERACTIVE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L't', L'e', L'r', L'a', L'c', L't', L'i', L'v', L'e'};
static wchar_t* INTERACTIVE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = INTERACTIVE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* INTERACTIVE_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The verbal parameter for the move logic in cybol. */
static wchar_t VERBAL_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'v', L'e', L'r', L'b', L'a', L'l'};
static wchar_t* VERBAL_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME = VERBAL_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* VERBAL_MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* MOVE_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
