/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef INTERNAL_MEMORY_STATE_CYBOI_NAME_CONSTANT_SOURCE
#define INTERNAL_MEMORY_STATE_CYBOI_NAME_CONSTANT_SOURCE

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The knowledge memory. */
static int* KNOWLEDGE_MEMORY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The signal memory. */
static int* SIGNAL_MEMORY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_20_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SLEEP_TIME_SIGNAL_MEMORY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_23_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The serial port. */
static int* INTERRUPT_REQUEST_SERIAL_PORT_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_101_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* MUTEX_SERIAL_PORT_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_102_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SLEEP_TIME_SERIAL_PORT_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_103_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* HANDLER_SERIAL_PORT_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_104_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* FILE_DESCRIPTOR_SERIAL_PORT_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_110_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* ORIGINAL_ATTRIBUTES_SERIAL_PORT_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_120_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The server socket base numbers (segment).
 * There is one for each service.
 *
 * CAUTION! The difference between base numbers
 * (offset) depends on the amount of index numbers.
 * It currently has a value of 10.
 * See further below!
 */
static int* CYBOI_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_200_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* WWW_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_210_INTEGER_STATE_CYBOI_MODEL_ARRAY;
/*??
static int* TCP_MUX_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_500_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* FTP_DATA_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_525_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* FTP_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_550_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* FSP_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_575_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SSH_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_600_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* TELNET_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_625_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SMTP_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_650_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* POP3_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_700_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* HTTPS_BASE_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_725_INTEGER_STATE_CYBOI_MODEL_ARRAY;
*/

/**
 * The server socket index numbers, to be added on top of a base number.
 * There are currently not more than 10 entries.
 *
 * CAUTION! If changing the number of indices,
 * the base segment size HAS TO BE adapted as well.
 * See further above!
 */
static int* INTERRUPT_REQUEST_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* MUTEX_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SLEEP_TIME_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* HANDLER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;
/*??
static int* SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* DATA_ADDRESS_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SIZE_ADDRESS_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* DATA_STYLE_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_34_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* COUNT_STYLE_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_35_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* DATA_CHARACTER_BUFFER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_40_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* COUNT_CHARACTER_BUFFER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_41_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SIZE_CHARACTER_BUFFER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_42_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* COMMUNICATION_PARTNER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_50_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* ADDRESS_COMMUNICATION_PARTNER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_51_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* ADDRESS_SIZE_COMMUNICATION_PARTNER_SOCKET_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_52_INTEGER_STATE_CYBOI_MODEL_ARRAY;
*/

/** The terminal. */
static int* INTERRUPT_REQUEST_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_301_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* MUTEX_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_302_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SLEEP_TIME_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_303_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* HANDLER_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_304_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* INPUT_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_310_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* OUTPUT_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_311_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* ORIGINAL_ATTRIBUTES_TERMINAL_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_320_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The display. */
static int* INTERRUPT_REQUEST_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_401_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* MUTEX_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_402_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SLEEP_TIME_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_403_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* HANDLER_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_404_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* CONNECTION_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_411_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* SCREEN_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_412_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* WINDOW_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_421_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_442_INTEGER_STATE_CYBOI_MODEL_ARRAY;
//?? --
static int* COLOUR_MAP_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_430_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* BACKGROUND_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_431_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* FOREGROUND_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_432_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* VALUE_MASK_GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_440_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* VALUES_GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_441_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* MENU_GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_443_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* TOP_BORDER_MENU_GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_444_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* BOTTOM_BORDER_MENU_GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_445_INTEGER_STATE_CYBOI_MODEL_ARRAY;
static int* FONT_MENU_GRAPHIC_CONTEXT_X_WINDOW_SYSTEM_DISPLAY_INTERNAL_MEMORY_STATE_CYBOI_NAME = NUMBER_446_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* INTERNAL_MEMORY_STATE_CYBOI_NAME_CONSTANT_SOURCE */
#endif
