/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef NAMESPACE_SOCKET_CYBOL_MODEL_CONSTANT_SOURCE
#define NAMESPACE_SOCKET_CYBOL_MODEL_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The local namespace socket cybol model. */
static wchar_t LOCAL_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'l', L'o', L'c', L'a', L'l'};
static wchar_t* LOCAL_NAMESPACE_SOCKET_CYBOL_MODEL = LOCAL_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* LOCAL_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The internet protocol version 4 (ipv4) namespace socket cybol model. */
static wchar_t INET_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'i', L'p', L'v', L'4'};
static wchar_t* INET_NAMESPACE_SOCKET_CYBOL_MODEL = INET_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* INET_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The internet protocol version 6 (ipv6) namespace socket cybol model. */
static wchar_t INET6_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'i', L'p', L'v', L'6'};
static wchar_t* INET6_NAMESPACE_SOCKET_CYBOL_MODEL = INET6_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* INET6_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The xerox network software protocols namespace socket cybol model. */
static wchar_t NS_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'n', L's'};
static wchar_t* NS_NAMESPACE_SOCKET_CYBOL_MODEL = NS_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* NS_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The open systems interconnect (osi) namespace socket cybol model. */
static wchar_t ISO_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'i', L's', L'o'};
static wchar_t* ISO_NAMESPACE_SOCKET_CYBOL_MODEL = ISO_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* ISO_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ccitt namespace socket cybol model. */
static wchar_t CCITT_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'c', L'c', L'i', L't', L't'};
static wchar_t* CCITT_NAMESPACE_SOCKET_CYBOL_MODEL = CCITT_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* CCITT_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The internet cybol model processor namespace socket cybol model. */
static wchar_t IMPLINK_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'i', L'm', L'p', L'l', L'i', L'n', L'k'};
static wchar_t* IMPLINK_NAMESPACE_SOCKET_CYBOL_MODEL = IMPLINK_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* IMPLINK_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The local area routing protocol namespace socket cybol model. */
static wchar_t ROUTE_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY[] = {L'r', L'o', L'u', L't', L'e'};
static wchar_t* ROUTE_NAMESPACE_SOCKET_CYBOL_MODEL = ROUTE_NAMESPACE_SOCKET_CYBOL_MODEL_ARRAY;
static int* ROUTE_NAMESPACE_SOCKET_CYBOL_MODEL_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* NAMESPACE_SOCKET_CYBOL_MODEL_CONSTANT_SOURCE */
#endif
