/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.13.0 2013-03-29
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef ANSI_ESCAPE_CODE_MODEL_CONSTANT_SOURCE
#define ANSI_ESCAPE_CODE_MODEL_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/**
 * The prefix ansi escape code model.
 *
 * ESC[
 */
static wchar_t ESCAPE_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x001B, 0x005B};
static wchar_t* ESCAPE_ANSI_ESCAPE_CODE_MODEL = ESCAPE_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ESCAPE_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The erase display ansi escape code model.
 *
 * ESC[2J
 *
 * Mnemonic:
 * ED (Erase Display)
 */
static wchar_t ERASE_DISPLAY_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0032, 0x004A};
static wchar_t* ERASE_DISPLAY_ANSI_ESCAPE_CODE_MODEL = ERASE_DISPLAY_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ERASE_DISPLAY_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The erase line ansi escape code model.
 *
 * ESC[K
 *
 * Mnemonic:
 * EL (Erase Line)
 */
static wchar_t ERASE_LINE_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x004B};
static wchar_t* ERASE_LINE_ANSI_ESCAPE_CODE_MODEL = ERASE_LINE_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ERASE_LINE_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The cursor position ansi escape code model.
 *
 * ESC[P;PH
 *
 * Mnemonic:
 * CUP (Cursor Position)
 * HVP (Horizontal and Vertical Position)
 */
static wchar_t CURSOR_POSITION_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0078, 0x0048};
static wchar_t* CURSOR_POSITION_ANSI_ESCAPE_CODE_MODEL = CURSOR_POSITION_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* CURSOR_POSITION_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// The set graphics rendition.
//
// ESC[P;...;Pm
//
// Mnemonic:
// SGR (Set Graphics Rendition)
//

/** The attribute suffix ansi escape code model. */
static wchar_t ATTRIBUTE_SUFFIX_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x006D};
static wchar_t* ATTRIBUTE_SUFFIX_ANSI_ESCAPE_CODE_MODEL = ATTRIBUTE_SUFFIX_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ATTRIBUTE_SUFFIX_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The attribute off ansi escape code model. */
static wchar_t ATTRIBUTE_OFF_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0030, 0x006D};
static wchar_t* ATTRIBUTE_OFF_ANSI_ESCAPE_CODE_MODEL = ATTRIBUTE_OFF_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ATTRIBUTE_OFF_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The bold ansi escape code model. */
static wchar_t BOLD_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0031, 0x006D};
static wchar_t* BOLD_ANSI_ESCAPE_CODE_MODEL = BOLD_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* BOLD_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The underline ansi escape code model. */
static wchar_t UNDERLINE_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x006D};
static wchar_t* UNDERLINE_ANSI_ESCAPE_CODE_MODEL = UNDERLINE_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* UNDERLINE_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The blink ansi escape code model. */
static wchar_t BLINK_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0035, 0x006D};
static wchar_t* BLINK_ANSI_ESCAPE_CODE_MODEL = BLINK_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* BLINK_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The inverse ansi escape code model. */
static wchar_t INVERSE_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0037, 0x006D};
static wchar_t* INVERSE_ANSI_ESCAPE_CODE_MODEL = INVERSE_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* INVERSE_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The hidden ansi escape code model. */
static wchar_t HIDDEN_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0038, 0x006D};
static wchar_t* HIDDEN_ANSI_ESCAPE_CODE_MODEL = HIDDEN_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* HIDDEN_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The black foreground ansi escape code model. */
static wchar_t BLACK_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0030};
static wchar_t* BLACK_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = BLACK_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* BLACK_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The red foreground ansi escape code model. */
static wchar_t RED_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0031};
static wchar_t* RED_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = RED_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* RED_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The green foreground ansi escape code model. */
static wchar_t GREEN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0032};
static wchar_t* GREEN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = GREEN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* GREEN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The yellow foreground ansi escape code model. */
static wchar_t YELLOW_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0033};
static wchar_t* YELLOW_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = YELLOW_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* YELLOW_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The blue foreground ansi escape code model. */
static wchar_t BLUE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0034};
static wchar_t* BLUE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = BLUE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* BLUE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The magenta (violet, purple, mauve) foreground ansi escape code model. */
static wchar_t MAGENTA_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0035};
static wchar_t* MAGENTA_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = MAGENTA_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* MAGENTA_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The cyan blue (china blue) foreground ansi escape code model. */
static wchar_t CYAN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0036};
static wchar_t* CYAN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = CYAN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* CYAN_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The white foreground ansi escape code model. */
static wchar_t WHITE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0033, 0x0037};
static wchar_t* WHITE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL = WHITE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* WHITE_FOREGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The black background ansi escape code model. */
static wchar_t BLACK_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0030};
static wchar_t* BLACK_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = BLACK_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* BLACK_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The red background ansi escape code model. */
static wchar_t RED_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0031};
static wchar_t* RED_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = RED_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* RED_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The green background ansi escape code model. */
static wchar_t GREEN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0032};
static wchar_t* GREEN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = GREEN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* GREEN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The yellow background ansi escape code model. */
static wchar_t YELLOW_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0033};
static wchar_t* YELLOW_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = YELLOW_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* YELLOW_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The blue background ansi escape code model. */
static wchar_t BLUE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0034};
static wchar_t* BLUE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = BLUE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* BLUE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The magenta (violet, purple, mauve) background ansi escape code model. */
static wchar_t MAGENTA_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0035};
static wchar_t* MAGENTA_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = MAGENTA_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* MAGENTA_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The cyan blue (china blue) background ansi escape code model. */
static wchar_t CYAN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0036};
static wchar_t* CYAN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = CYAN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* CYAN_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The white background ansi escape code model. */
static wchar_t WHITE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0034, 0x0037};
static wchar_t* WHITE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL = WHITE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* WHITE_BACKGROUND_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Terminal input.
//
// Example: The "arrow up" key delivers: ESC[A
//

/** The arrow up ansi escape code model. */
static wchar_t ARROW_UP_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0041};
static wchar_t* ARROW_UP_ANSI_ESCAPE_CODE_MODEL = ARROW_UP_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ARROW_UP_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The arrow down ansi escape code model. */
static wchar_t ARROW_DOWN_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0042};
static wchar_t* ARROW_DOWN_ANSI_ESCAPE_CODE_MODEL = ARROW_DOWN_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ARROW_DOWN_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The arrow left ansi escape code model. */
static wchar_t ARROW_LEFT_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0044};
static wchar_t* ARROW_LEFT_ANSI_ESCAPE_CODE_MODEL = ARROW_LEFT_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ARROW_LEFT_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The arrow right ansi escape code model. */
static wchar_t ARROW_RIGHT_ANSI_ESCAPE_CODE_MODEL_ARRAY[] = {0x0043};
static wchar_t* ARROW_RIGHT_ANSI_ESCAPE_CODE_MODEL = ARROW_RIGHT_ANSI_ESCAPE_CODE_MODEL_ARRAY;
static int* ARROW_RIGHT_ANSI_ESCAPE_CODE_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* ANSI_ESCAPE_CODE_MODEL_CONSTANT_SOURCE */
#endif
