/*
 * Copyright (C) 1999-2012. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.12.0 2012-08-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TEXT_USER_INTERFACE_CYBOL_NAME_CONSTANT_SOURCE
#define TEXT_USER_INTERFACE_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The background colour user interface cybol name. */
static wchar_t BACKGROUND_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'b', L'a', L'c', L'k', L'g', L'r', L'o', L'u', L'n', L'd'};
static wchar_t* BACKGROUND_TEXT_USER_INTERFACE_CYBOL_NAME = BACKGROUND_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* BACKGROUND_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The blink text user interface cybol name. */
static wchar_t BLINK_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'b', L'l', L'i', L'n', L'k'};
static wchar_t* BLINK_TEXT_USER_INTERFACE_CYBOL_NAME = BLINK_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* BLINK_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The bold text user interface cybol name. */
static wchar_t BOLD_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'b', L'o', L'l', L'd'};
static wchar_t* BOLD_TEXT_USER_INTERFACE_CYBOL_NAME = BOLD_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* BOLD_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The border text user interface cybol name. */
static wchar_t BORDER_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'b', L'o', L'r', L'd', L'e', L'r'};
static wchar_t* BORDER_TEXT_USER_INTERFACE_CYBOL_NAME = BORDER_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* BORDER_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The foreground colour user interface cybol name. */
static wchar_t FOREGROUND_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'e', L'g', L'r', L'o', L'u', L'n', L'd'};
static wchar_t* FOREGROUND_TEXT_USER_INTERFACE_CYBOL_NAME = FOREGROUND_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* FOREGROUND_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The hidden text user interface cybol name. */
static wchar_t HIDDEN_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'h', L'i', L'd', L'd', L'e', L'n'};
static wchar_t* HIDDEN_TEXT_USER_INTERFACE_CYBOL_NAME = HIDDEN_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* HIDDEN_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The inverse text user interface cybol name. */
static wchar_t INVERSE_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'v', L'e', L'r', L's', L'e'};
static wchar_t* INVERSE_TEXT_USER_INTERFACE_CYBOL_NAME = INVERSE_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* INVERSE_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The position user interface cybol name. */
static wchar_t POSITION_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'p', L'o', L's', L'i', L't', L'i', L'o', L'n'};
static wchar_t* POSITION_TEXT_USER_INTERFACE_CYBOL_NAME = POSITION_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* POSITION_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The size user interface cybol name. */
static wchar_t SIZE_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L's', L'i', L'z', L'e'};
static wchar_t* SIZE_TEXT_USER_INTERFACE_CYBOL_NAME = SIZE_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* SIZE_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The underline text user interface cybol name. */
static wchar_t UNDERLINE_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'u', L'n', L'd', L'e', L'r', L'l', L'i', L'n', L'e'};
static wchar_t* UNDERLINE_TEXT_USER_INTERFACE_CYBOL_NAME = UNDERLINE_TEXT_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* UNDERLINE_TEXT_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* TEXT_USER_INTERFACE_CYBOL_NAME_CONSTANT_SOURCE */
#endif
