/*
 * Copyright (C) 1999-2012. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.12.0 2012-08-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef APPEND_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE
#define APPEND_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination append modification operation cybol name. */
static wchar_t DESTINATION_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_APPEND_MODIFICATION_OPERATION_CYBOL_NAME = DESTINATION_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* DESTINATION_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source append modification operation cybol name. */
static wchar_t SOURCE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME = SOURCE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* SOURCE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type append modification operation cybol name. */
static wchar_t TYPE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME = TYPE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* TYPE_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The count append modification operation cybol name. */
static wchar_t COUNT_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'u', L'n', L't'};
static wchar_t* COUNT_APPEND_MODIFICATION_OPERATION_CYBOL_NAME = COUNT_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* COUNT_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The index append modification operation cybol name. */
static wchar_t INDEX_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'd', L'e', L'x'};
static wchar_t* INDEX_APPEND_MODIFICATION_OPERATION_CYBOL_NAME = INDEX_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* INDEX_APPEND_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* APPEND_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE */
#endif
