/*
 * Copyright (C) 1999-2012. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.12.0 2012-08-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_CONSTANT_SOURCE
#define STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The channel startup maintenance operation cybol name. */
static wchar_t CHANNEL_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY[] = {L'c', L'h', L'a', L'n', L'n', L'e', L'l'};
static wchar_t* CHANNEL_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME = CHANNEL_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY;
static int* CHANNEL_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The namespace startup maintenance operation cybol name. */
static wchar_t NAMESPACE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY[] = {L'n', L'a', L'm', L'e', L's', L'p', L'a', L'c', L'e'};
static wchar_t* NAMESPACE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME = NAMESPACE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY;
static int* NAMESPACE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The style startup maintenance operation cybol name. */
static wchar_t STYLE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L't', L'y', L'l', L'e'};
static wchar_t* STYLE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME = STYLE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY;
static int* STYLE_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The address startup maintenance operation cybol name. */
static wchar_t ADDRESS_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'd', L'd', L'r', L'e', L's', L's'};
static wchar_t* ADDRESS_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME = ADDRESS_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_ARRAY;
static int* ADDRESS_STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* STARTUP_MAINTENANCE_OPERATION_CYBOL_NAME_CONSTANT_SOURCE */
#endif
