/*
 * Copyright (C) 1999-2012. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.11.0 2012-01-01
 * @author Christian Heller <christian.heller@tuxtax.de>
 * @author Thomas Thiele
 * @author Friedemann Simon
 */

#ifndef CHARACTER_ENTITY_XML_MODEL_CONSTANT_SOURCE
#define CHARACTER_ENTITY_XML_MODEL_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The quotation mark character entity xml model. */
static wchar_t QUOTATION_MARK_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'q', L'u', L'o', L't'};
static wchar_t* QUOTATION_MARK_CHARACTER_ENTITY_XML_MODEL = QUOTATION_MARK_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* QUOTATION_MARK_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ampersand character entity xml model. */
static wchar_t AMPERSAND_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'a', L'm', L'p'};
static wchar_t* AMPERSAND_CHARACTER_ENTITY_XML_MODEL = AMPERSAND_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* AMPERSAND_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The apostrophe character entity xml model. CAUTION! It is only used in XHTML. */
static wchar_t APOSTROPHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'a', L'p', L'o', L's'};
static wchar_t* APOSTROPHE_CHARACTER_ENTITY_XML_MODEL = APOSTROPHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* APOSTROPHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The less than sign character entity xml model. */
static wchar_t LESS_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'l', L't'};
static wchar_t* LESS_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL = LESS_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* LESS_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The greater than sign character entity xml model. */
static wchar_t GREATER_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'g', L't'};
static wchar_t* GREATER_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL = GREATER_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* GREATER_THAN_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Greek letters
//

/** The small alpha character entity xml model. */
static wchar_t SMALL_ALPHA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'a', L'g', L'r'};
static wchar_t* SMALL_ALPHA_CHARACTER_ENTITY_XML_MODEL = SMALL_ALPHA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ALPHA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Alpha character entity xml model. */
static wchar_t CAPITAL_ALPHA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'A', L'g', L'r'};
static wchar_t* CAPITAL_ALPHA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ALPHA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ALPHA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small beta character entity xml model. */
static wchar_t SMALL_BETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'b', L'g', L'r'};
static wchar_t* SMALL_BETA_CHARACTER_ENTITY_XML_MODEL = SMALL_BETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_BETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capial Beta character entity xml model. */
static wchar_t CAPITAL_BETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'B', L'g', L'r'};
static wchar_t* CAPITAL_BETA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_BETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_BETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small gamma character entity xml model. */
static wchar_t SMALL_GAMMA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'g', L'g', L'r'};
static wchar_t* SMALL_GAMMA_CHARACTER_ENTITY_XML_MODEL = SMALL_GAMMA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_GAMMA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Gamma character entity xml model. */
static wchar_t CAPITAL_GAMMA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'G', L'g', L'r'};
static wchar_t* CAPITAL_GAMMA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_GAMMA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_GAMMA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small delta character entity xml model. */
static wchar_t SMALL_DELTA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'd', L'g', L'r'};
static wchar_t* SMALL_DELTA_CHARACTER_ENTITY_XML_MODEL = SMALL_DELTA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_DELTA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Delta character entity xml model. */
static wchar_t CAPITAL_DELTA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'D', L'g', L'r'};
static wchar_t* CAPITAL_DELTA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_DELTA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_DELTA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small epsilon character entity xml model. */
static wchar_t SMALL_EPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'e', L'g', L'r'};
static wchar_t* SMALL_EPSILON_CHARACTER_ENTITY_XML_MODEL = SMALL_EPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_EPSILON_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Epsilon character entity xml model. */
static wchar_t CAPITAL_EPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'E', L'g', L'r'};
static wchar_t* CAPITAL_EPSILON_CHARACTER_ENTITY_XML_MODEL = CAPITAL_EPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_EPSILON_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small zeta character entity xml model. */
static wchar_t SMALL_ZETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'z', L'g', L'r'};
static wchar_t* SMALL_ZETA_CHARACTER_ENTITY_XML_MODEL = SMALL_ZETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ZETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Zeta character entity xml model. */
static wchar_t CAPITAL_ZETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'Z', L'g', L'r'};
static wchar_t* CAPITAL_ZETA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ZETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ZETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small eta character entity xml model. */
static wchar_t SMALL_ETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'e', L'e', L'g', L'r'};
static wchar_t* SMALL_ETA_CHARACTER_ENTITY_XML_MODEL = SMALL_ETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Eta character entity xml model. */
static wchar_t CAPITAL_ETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'E', L'e', L'g', L'r'};
static wchar_t* CAPITAL_ETA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small theta character entity xml model. */
static wchar_t SMALL_THETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L't', L'h', L'g', L'r'};
static wchar_t* SMALL_THETA_CHARACTER_ENTITY_XML_MODEL = SMALL_THETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_THETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Theta character entity xml model. */
static wchar_t CAPITAL_THETA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'T', L'h', L'g', L'r'};
static wchar_t* CAPITAL_THETA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_THETA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_THETA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small iota character entity xml model. */
static wchar_t SMALL_IOTA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'i', L'g', L'r'};
static wchar_t* SMALL_IOTA_CHARACTER_ENTITY_XML_MODEL = SMALL_IOTA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_IOTA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Iota character entity xml model. */
static wchar_t CAPITAL_IOTA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'I', L'g', L'r'};
static wchar_t* CAPITAL_IOTA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_IOTA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_IOTA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small kappa character entity xml model. */
static wchar_t SMALL_KAPPA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'k', L'g', L'r'};
static wchar_t* SMALL_KAPPA_CHARACTER_ENTITY_XML_MODEL = SMALL_KAPPA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_KAPPA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Kappa character entity xml model. */
static wchar_t CAPITAL_KAPPA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'K', L'g', L'r'};
static wchar_t* CAPITAL_KAPPA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_KAPPA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_KAPPA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small lambda character entity xml model. */
static wchar_t SMALL_LAMBDA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'l', L'g', L'r'};
static wchar_t* SMALL_LAMBDA_CHARACTER_ENTITY_XML_MODEL = SMALL_LAMBDA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_LAMBDA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Lambda character entity xml model. */
static wchar_t CAPITAL_LAMBDA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'L', L'g', L'r'};
static wchar_t* CAPITAL_LAMBDA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_LAMBDA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_LAMBDA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small mu character entity xml model. */
static wchar_t SMALL_MU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'm', L'g', L'r'};
static wchar_t* SMALL_MU_CHARACTER_ENTITY_XML_MODEL = SMALL_MU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_MU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Mu character entity xml model. */
static wchar_t CAPITAL_MU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'M', L'g', L'r'};
static wchar_t* CAPITAL_MU_CHARACTER_ENTITY_XML_MODEL = CAPITAL_MU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_MU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small nu character entity xml model. */
static wchar_t SMALL_NU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'n', L'g', L'r'};
static wchar_t* SMALL_NU_CHARACTER_ENTITY_XML_MODEL = SMALL_NU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_NU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Nu character entity xml model. */
static wchar_t CAPITAL_NU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'N', L'g', L'r'};
static wchar_t* CAPITAL_NU_CHARACTER_ENTITY_XML_MODEL = CAPITAL_NU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_NU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small xi character entity xml model. */
static wchar_t SMALL_XI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'x', L'g', L'r'};
static wchar_t* SMALL_XI_CHARACTER_ENTITY_XML_MODEL = SMALL_XI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_XI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Xi character entity xml model. */
static wchar_t CAPITAL_XI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'X', L'g', L'r'};
static wchar_t* CAPITAL_XI_CHARACTER_ENTITY_XML_MODEL = CAPITAL_XI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_XI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small omicron character entity xml model. */
static wchar_t SMALL_OMICRON_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'o', L'g', L'r'};
static wchar_t* SMALL_OMICRON_CHARACTER_ENTITY_XML_MODEL = SMALL_OMICRON_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_OMICRON_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Omicron character entity xml model. */
static wchar_t CAPITAL_OMICRON_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'O', L'g', L'r'};
static wchar_t* CAPITAL_OMICRON_CHARACTER_ENTITY_XML_MODEL = CAPITAL_OMICRON_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_OMICRON_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small pi character entity xml model. */
static wchar_t SMALL_PI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'p', L'g', L'r'};
static wchar_t* SMALL_PI_CHARACTER_ENTITY_XML_MODEL = SMALL_PI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_PI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Pi character entity xml model. */
static wchar_t CAPITAL_PI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'P', L'g', L'r'};
static wchar_t* CAPITAL_PI_CHARACTER_ENTITY_XML_MODEL = CAPITAL_PI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_PI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small rho character entity xml model. */
static wchar_t SMALL_RHO_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'r', L'g', L'r'};
static wchar_t* SMALL_RHO_CHARACTER_ENTITY_XML_MODEL = SMALL_RHO_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_RHO_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Rho character entity xml model. */
static wchar_t CAPITAL_RHO_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'R', L'g', L'r'};
static wchar_t* CAPITAL_RHO_CHARACTER_ENTITY_XML_MODEL = CAPITAL_RHO_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_RHO_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small sigma character entity xml model. */
static wchar_t SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L's', L'g', L'r'};
static wchar_t* SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL = SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Sigma character entity xml model. */
static wchar_t CAPITAL_SIGMA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'S', L'g', L'r'};
static wchar_t* CAPITAL_SIGMA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_SIGMA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_SIGMA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The final small sigma character entity xml model. */
static wchar_t FINAL_SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L's', L'f', L'g', L'r'};
static wchar_t* FINAL_SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL = FINAL_SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* FINAL_SMALL_SIGMA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small tau character entity xml model. */
static wchar_t SMALL_TAU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L't', L'g', L'r'};
static wchar_t* SMALL_TAU_CHARACTER_ENTITY_XML_MODEL = SMALL_TAU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_TAU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Tau character entity xml model. */
static wchar_t CAPITAL_TAU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'T', L'g', L'r'};
static wchar_t* CAPITAL_TAU_CHARACTER_ENTITY_XML_MODEL = CAPITAL_TAU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_TAU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small upsilon character entity xml model. */
static wchar_t SMALL_UPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'u', L'g', L'r'};
static wchar_t* SMALL_UPSILON_CHARACTER_ENTITY_XML_MODEL = SMALL_UPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_UPSILON_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Upsilon character entity xml model. */
static wchar_t CAPITAL_UPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'U', L'g', L'r'};
static wchar_t* CAPITAL_UPSILON_CHARACTER_ENTITY_XML_MODEL = CAPITAL_UPSILON_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_UPSILON_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small phi character entity xml model. */
static wchar_t SMALL_PHI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'p', L'h', L'g', L'r'};
static wchar_t* SMALL_PHI_CHARACTER_ENTITY_XML_MODEL = SMALL_PHI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_PHI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Phi character entity xml model. */
static wchar_t CAPITAL_PHI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'P', L'H', L'g', L'r'};
static wchar_t* CAPITAL_PHI_CHARACTER_ENTITY_XML_MODEL = CAPITAL_PHI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_PHI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small chi character entity xml model. */
static wchar_t SMALL_CHI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'k', L'h', L'g', L'r'};
static wchar_t* SMALL_CHI_CHARACTER_ENTITY_XML_MODEL = SMALL_CHI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_CHI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Chi character entity xml model. */
static wchar_t CAPITAL_CHI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'K', L'H', L'g', L'r'};
static wchar_t* CAPITAL_CHI_CHARACTER_ENTITY_XML_MODEL = CAPITAL_CHI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_CHI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small psi character entity xml model. */
static wchar_t SMALL_PSI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'p', L's', L'g'; L'r'};
static wchar_t* SMALL_PSI_CHARACTER_ENTITY_XML_MODEL = SMALL_PSI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_PSI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Psi character entity xml model. */
static wchar_t CAPITAL_PSI_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'P', L'S', L'g', L'r'};
static wchar_t* CAPITAL_PSI_CHARACTER_ENTITY_XML_MODEL = CAPITAL_PSI_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_PSI_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small omega character entity xml model. */
static wchar_t SMALL_OMEGA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'o', L'h', L'g'; L'r'};
static wchar_t* SMALL_OMEGA_CHARACTER_ENTITY_XML_MODEL = SMALL_OMEGA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_OMEGA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital Omega character entity xml model. */
static wchar_t CAPITAL_OMEGA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'O', L'H', L'g', L'r'};
static wchar_t* CAPITAL_OMEGA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_OMEGA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_OMEGA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Russian cyrillic
//

/** The small a character entity xml model. */
static wchar_t SMALL_A_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'a', L'c', L'y'};
static wchar_t* SMALL_A_CHARACTER_ENTITY_XML_MODEL = SMALL_A_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_A_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital A character entity xml model. */
static wchar_t CAPITAL_A_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'A', L'c', L'y'};
static wchar_t* CAPITAL_A_CHARACTER_ENTITY_XML_MODEL = CAPITAL_A_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_A_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small be character entity xml model. */
static wchar_t SMALL_BE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'b', L'c', L'y'};
static wchar_t* SMALL_BE_CHARACTER_ENTITY_XML_MODEL = SMALL_BE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_BE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital BE character entity xml model. */
static wchar_t CAPITAL_BE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'B', L'c', L'y'};
static wchar_t* CAPITAL_BE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_BE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_BE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ve character entity xml model. */
static wchar_t SMALL_VE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'v', L'c', L'y'};
static wchar_t* SMALL_VE_CHARACTER_ENTITY_XML_MODEL = SMALL_VE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_VE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital VE character entity xml model. */
static wchar_t CAPITAL_VE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'V', L'c', L'y'};
static wchar_t* CAPITAL_VE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_VE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_VE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ghe character entity xml model. */
static wchar_t SMALL_GHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'g', L'c', L'y'};
static wchar_t* SMALL_GHE_CHARACTER_ENTITY_XML_MODEL = SMALL_GHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_GHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital GHE character entity xml model. */
static wchar_t CAPITAL_GHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'G', L'c', L'y'};
static wchar_t* CAPITAL_GHE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_GHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_GHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small de character entity xml model. */
static wchar_t SMALL_DE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'd', L'c', L'y'};
static wchar_t* SMALL_DE_CHARACTER_ENTITY_XML_MODEL = SMALL_DE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_DE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital DE character entity xml model. */
static wchar_t CAPITAL_DE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'D', L'c', L'y'};
static wchar_t* CAPITAL_DE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_DE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_DE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ie character entity xml model. */
static wchar_t SMALL_IE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'i', L'e', L'c', L'y'};
static wchar_t* SMALL_IE_CHARACTER_ENTITY_XML_MODEL = SMALL_IE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_IE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital IE character entity xml model. */
static wchar_t CAPITAL_IE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'I', L'E', L'c', L'y'};
static wchar_t* CAPITAL_IE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_IE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_IE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small io character entity xml model. */
static wchar_t SMALL_IO_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'i', L'o', L'c', L'y'};
static wchar_t* SMALL_IO_CHARACTER_ENTITY_XML_MODEL = SMALL_IO_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_IO_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital IO character entity xml model. */
static wchar_t CAPITAL_IO_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'I', L'O', L'c', L'y'};
static wchar_t* CAPITAL_IO_CHARACTER_ENTITY_XML_MODEL = CAPITAL_IO_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_IO_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small zhe character entity xml model. */
static wchar_t SMALL_ZHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'z', L'h', L'c', L'y'};
static wchar_t* SMALL_ZHE_CHARACTER_ENTITY_XML_MODEL = SMALL_ZHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ZHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital ZHE character entity xml model. */
static wchar_t CAPITAL_ZHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'Z', L'H', L'c', L'y'};
static wchar_t* CAPITAL_ZHE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ZHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ZHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ze character entity xml model. */
static wchar_t SMALL_ZE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'z', L'c', L'y'};
static wchar_t* SMALL_ZE_CHARACTER_ENTITY_XML_MODEL = SMALL_ZE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ZE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital ZE character entity xml model. */
static wchar_t CAPITAL_ZE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'Z', L'c', L'y'};
static wchar_t* CAPITAL_ZE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ZE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ZE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small i character entity xml model. */
static wchar_t SMALL_I_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'i', L'c', L'y'};
static wchar_t* SMALL_I_CHARACTER_ENTITY_XML_MODEL = SMALL_I_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_I_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital I character entity xml model. */
static wchar_t CAPITAL_I_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'I', L'c', L'y'};
static wchar_t* CAPITAL_I_CHARACTER_ENTITY_XML_MODEL = CAPITAL_I_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_I_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small short i character entity xml model. */
static wchar_t SMALL_SHORT_I_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'j', L'c', L'y'};
static wchar_t* SMALL_SHORT_I_CHARACTER_ENTITY_XML_MODEL = SMALL_SHORT_I_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_SHORT_I_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital short I character entity xml model. */
static wchar_t CAPITAL_SHORT_I_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'J', L'c', L'y'};
static wchar_t* CAPITAL_SHORT_I_CHARACTER_ENTITY_XML_MODEL = CAPITAL_SHORT_I_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_SHORT_I_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ka character entity xml model. */
static wchar_t SMALL_KA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'k', L'c', L'y'};
static wchar_t* SMALL_KA_CHARACTER_ENTITY_XML_MODEL = SMALL_KA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_KA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital KA character entity xml model. */
static wchar_t CAPITAL_KA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'K', L'c', L'y'};
static wchar_t* CAPITAL_KA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_KA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_KA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small el character entity xml model. */
static wchar_t SMALL_EL_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'l', L'c', L'y'};
static wchar_t* SMALL_EL_CHARACTER_ENTITY_XML_MODEL = SMALL_EL_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_EL_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital EL character entity xml model. */
static wchar_t CAPITAL_EL_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'L', L'c', L'y'};
static wchar_t* CAPITAL_EL_CHARACTER_ENTITY_XML_MODEL = CAPITAL_EL_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_EL_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small em character entity xml model. */
static wchar_t SMALL_EM_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'm', L'c', L'y'};
static wchar_t* SMALL_EM_CHARACTER_ENTITY_XML_MODEL = SMALL_EM_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_EM_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital EM character entity xml model. */
static wchar_t CAPITAL_EM_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'M', L'c', L'y'};
static wchar_t* CAPITAL_EM_CHARACTER_ENTITY_XML_MODEL = CAPITAL_EM_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_EM_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small en character entity xml model. */
static wchar_t SMALL_EN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'n', L'c', L'y'};
static wchar_t* SMALL_EN_CHARACTER_ENTITY_XML_MODEL = SMALL_EN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_EN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital EN character entity xml model. */
static wchar_t CAPITAL_EN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'N', L'c', L'y'};
static wchar_t* CAPITAL_EN_CHARACTER_ENTITY_XML_MODEL = CAPITAL_EN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_EN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small o character entity xml model. */
static wchar_t SMALL_O_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'o', L'c', L'y'};
static wchar_t* SMALL_O_CHARACTER_ENTITY_XML_MODEL = SMALL_O_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_O_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital O character entity xml model. */
static wchar_t CAPITAL_O_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'O', L'c', L'y'};
static wchar_t* CAPITAL_O_CHARACTER_ENTITY_XML_MODEL = CAPITAL_O_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_O_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small pe character entity xml model. */
static wchar_t SMALL_PE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'p', L'c', L'y'};
static wchar_t* SMALL_PE_CHARACTER_ENTITY_XML_MODEL = SMALL_PE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_PE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital PE character entity xml model. */
static wchar_t CAPITAL_PE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'P', L'c', L'y'};
static wchar_t* CAPITAL_PE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_PE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_PE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small er character entity xml model. */
static wchar_t SMALL_ER_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'r', L'c', L'y'};
static wchar_t* SMALL_ER_CHARACTER_ENTITY_XML_MODEL = SMALL_ER_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ER_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital ER character entity xml model. */
static wchar_t CAPITAL_ER_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'R', L'c', L'y'};
static wchar_t* CAPITAL_ER_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ER_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ER_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small es character entity xml model. */
static wchar_t SMALL_ES_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L's', L'c', L'y'};
static wchar_t* SMALL_ES_CHARACTER_ENTITY_XML_MODEL = SMALL_ES_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_ES_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital ES character entity xml model. */
static wchar_t CAPITAL_ES_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'S', L'c', L'y'};
static wchar_t* CAPITAL_ES_CHARACTER_ENTITY_XML_MODEL = CAPITAL_ES_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_ES_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small te character entity xml model. */
static wchar_t SMALL_TE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L't', L'c', L'y'};
static wchar_t* SMALL_TE_CHARACTER_ENTITY_XML_MODEL = SMALL_TE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_TE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital TE character entity xml model. */
static wchar_t CAPITAL_TE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'T', L'c', L'y'};
static wchar_t* CAPITAL_TE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_TE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_TE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small u character entity xml model. */
static wchar_t SMALL_U_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'u', L'c', L'y'};
static wchar_t* SMALL_U_CHARACTER_ENTITY_XML_MODEL = SMALL_U_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_U_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital U character entity xml model. */
static wchar_t CAPITAL_U_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'U', L'c', L'y'};
static wchar_t* CAPITAL_U_CHARACTER_ENTITY_XML_MODEL = CAPITAL_U_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_U_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ef character entity xml model. */
static wchar_t SMALL_EF_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'f', L'c', L'y'};
static wchar_t* SMALL_EF_CHARACTER_ENTITY_XML_MODEL = SMALL_EF_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_EF_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital EF character entity xml model. */
static wchar_t CAPITAL_EF_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'F', L'c', L'y'};
static wchar_t* CAPITAL_EF_CHARACTER_ENTITY_XML_MODEL = CAPITAL_EF_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_EF_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ha character entity xml model. */
static wchar_t SMALL_HA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'k', L'h', L'c', L'y'};
static wchar_t* SMALL_HA_CHARACTER_ENTITY_XML_MODEL = SMALL_HA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_HA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital HA character entity xml model. */
static wchar_t CAPITAL_HA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'K', L'H', L'c', L'y'};
static wchar_t* CAPITAL_HA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_HA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_HA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small tse character entity xml model. */
static wchar_t SMALL_TSE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L't', L's', L'c', L'y'};
static wchar_t* SMALL_TSE_CHARACTER_ENTITY_XML_MODEL = SMALL_TSE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_TSE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital TSE character entity xml model. */
static wchar_t CAPITAL_TSE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'T', L'S', L'c', L'y'};
static wchar_t* CAPITAL_TSE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_TSE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_TSE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small che character entity xml model. */
static wchar_t SMALL_CHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'c', L'h', L'c', L'y'};
static wchar_t* SMALL_CHE_CHARACTER_ENTITY_XML_MODEL = SMALL_CHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_CHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital CHE character entity xml model. */
static wchar_t CAPITAL_CHE_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'C', L'H', L'c', L'y'};
static wchar_t* CAPITAL_CHE_CHARACTER_ENTITY_XML_MODEL = CAPITAL_CHE_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_CHE_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small sha character entity xml model. */
static wchar_t SMALL_SHA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L's', L'h', L'c', L'y'};
static wchar_t* SMALL_SHA_CHARACTER_ENTITY_XML_MODEL = SMALL_SHA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_SHA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital SHA character entity xml model. */
static wchar_t CAPITAL_SHA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'S', L'H', L'c', L'y'};
static wchar_t* CAPITAL_SHA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_SHA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_SHA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small shcha character entity xml model. */
static wchar_t SMALL_SHCHA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L's', L'h', L'c', L'h', L'c', L'y'};
static wchar_t* SMALL_SHCHA_CHARACTER_ENTITY_XML_MODEL = SMALL_SHCHA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_SHCHA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital SHCHA character entity xml model. */
static wchar_t CAPITAL_SHCHA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'S', L'H', L'C', L'H', L'c', L'y'};
static wchar_t* CAPITAL_SHCHA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_SHCHA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_SHCHA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small hard sign character entity xml model. */
static wchar_t SMALL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'h', L'a', L'r', L'd', L'c', L'y'};
static wchar_t* SMALL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL = SMALL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital HARD sign character entity xml model. */
static wchar_t CAPITAL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'H', L'A', L'R', L'D', L'c', L'y'};
static wchar_t* CAPITAL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL = CAPITAL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_HARD_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small yeru character entity xml model. */
static wchar_t SMALL_YERU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'y', L'c', L'y'};
static wchar_t* SMALL_YERU_CHARACTER_ENTITY_XML_MODEL = SMALL_YERU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_YERU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital YERU character entity xml model. */
static wchar_t CAPITAL_YERU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'Y', L'c', L'y'};
static wchar_t* CAPITAL_YERU_CHARACTER_ENTITY_XML_MODEL = CAPITAL_YERU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_YERU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small soft sign character entity xml model. */
static wchar_t SMALL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L's', L'o', L'f', L't', L'c', L'y'};
static wchar_t* SMALL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL = SMALL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital SOFT sign character entity xml model. */
static wchar_t CAPITAL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'S', L'O', L'F', L'T', L'c', L'y'};
static wchar_t* CAPITAL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL = CAPITAL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_SOFT_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small e character entity xml model. */
static wchar_t SMALL_E_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'e', L'c', L'y'};
static wchar_t* SMALL_E_CHARACTER_ENTITY_XML_MODEL = SMALL_E_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_E_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital E character entity xml model. */
static wchar_t CAPITAL_E_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'E', L'c', L'y'};
static wchar_t* CAPITAL_E_CHARACTER_ENTITY_XML_MODEL = CAPITAL_E_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_E_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small yu character entity xml model. */
static wchar_t SMALL_YU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'y', L'u', L'c', L'y'};
static wchar_t* SMALL_YU_CHARACTER_ENTITY_XML_MODEL = SMALL_YU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_YU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital YU character entity xml model. */
static wchar_t CAPITAL_YU_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'Y', L'U', L'c', L'y'};
static wchar_t* CAPITAL_YU_CHARACTER_ENTITY_XML_MODEL = CAPITAL_YU_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_YU_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The small ya character entity xml model. */
static wchar_t SMALL_YA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'y', L'a', L'c', L'y'};
static wchar_t* SMALL_YA_CHARACTER_ENTITY_XML_MODEL = SMALL_YA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* SMALL_YA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capital YA character entity xml model. */
static wchar_t CAPITAL_YA_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'Y', L'A', L'c', L'y'};
static wchar_t* CAPITAL_YA_CHARACTER_ENTITY_XML_MODEL = CAPITAL_YA_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* CAPITAL_YA_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numero sign character entity xml model. */
static wchar_t NUMERO_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'n', L'u', L'm', L'e', L'r', L'o'};
static wchar_t* NUMERO_SIGN_CHARACTER_ENTITY_XML_MODEL = NUMERO_SIGN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* NUMERO_SIGN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Math symbols: delimiters
//

/** The right ceiling character entity xml model. */
static wchar_t RIGHT_CEILING_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'r', L'c', L'e', L'i', L'l'};
static wchar_t* RIGHT_CEILING_CHARACTER_ENTITY_XML_MODEL = RIGHT_CEILING_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* RIGHT_CEILING_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right floor character entity xml model. */
static wchar_t RIGHT_FLOOR_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'r', L'f', L'l', L'o', L'o', L'r'};
static wchar_t* RIGHT_FLOOR_CHARACTER_ENTITY_XML_MODEL = RIGHT_FLOOR_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* RIGHT_FLOOR_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right paren, gt  character entity xml model. */
static wchar_t RIGHT_PAREN_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'r', L'p', L'a', L'r', L'g', L't'};
static wchar_t* RIGHT_PAREN_CHARACTER_ENTITY_XML_MODEL = RIGHT_PAREN_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* RIGHT_PAREN_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The upper right corner character entity xml model. */
static wchar_t UPPER_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'u', L'r', L'c', L'o', L'r', L'n'};
static wchar_t* UPPER_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL = UPPER_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* UPPER_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The downward right corner character entity xml model. */
static wchar_t DOWNWARD_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'd', L'r', L'c', L'o', L'r', L'n'};
static wchar_t* DOWNWARD_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL = DOWNWARD_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* DOWNWARD_RIGHT_CORNER_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left ceiling character entity xml model. */
static wchar_t LEFT_CEILING_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'l', L'c', L'e', L'i', L'l'};
static wchar_t* LEFT_CEILING_CHARACTER_ENTITY_XML_MODEL = LEFT_CEILING_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* LEFT_CEILING_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left floor character entity xml model. */
static wchar_t LEFT_FLOOR_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'l', L'f', L'l', L'o', L'o', L'r'};
static wchar_t* LEFT_FLOOR_CHARACTER_ENTITY_XML_MODEL = LEFT_FLOOR_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* LEFT_FLOOR_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left parenthesis, gt  character entity xml model. */
static wchar_t LEFT_PARENTHESIS_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'l', L'p', L'a', L'r', L'g', L't'};
static wchar_t* LEFT_PARENTHESIS_CHARACTER_ENTITY_XML_MODEL = LEFT_PARENTHESIS_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* LEFT_PARENTHESIS_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The upper left corner character entity xml model. */
static wchar_t UPPER_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'u', L'l', L'c', L'o', L'r', L'n'};
static wchar_t* UPPER_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL = UPPER_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* UPPER_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The downward left corner character entity xml model. */
static wchar_t DOWNWARD_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY[] = {L'd', L'l', L'c', L'o', L'r', L'n'};
static wchar_t* DOWNWARD_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL = DOWNWARD_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL_ARRAY;
static int* DOWNWARD_LEFT_CORNER_CHARACTER_ENTITY_XML_MODEL_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* CHARACTER_ENTITY_XML_MODEL_CONSTANT_SOURCE */
#endif
