/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           JawaaHash.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
This object is the main object storage facility for the Jawaa runtime.
Objects created by the user are stored in this data structure. Only
one copy of this class is instantiated everytime a Jawaa file is run.
-------------------------------------------------------------------------------*/
package jawaa.util;

import java.util.*;
import java.awt.Graphics;
import jawaa.object.*;
import jawaa.structure.JawaaContainer;


/**
 * A JawaaHash object serves as a container for JawaaObjects. The
 * unique names of particular objects are used as keys in a hashmap. A
 * JawaaHash is a smarter than a regular container such as a vector or
 * Hashmap. A JawaaHash is able to iterate over all of the objects in
 * the container and ask each object to paint itself.  Also, in the
 * case of arrays and other objects that are containers in themselves,
 * the JawaaHash can determine which element of that container is
 * needed and then fetch that particular element. JawaaHash also
 * implements Java1.2 style iterators. The iterator functions return
 * JawaaObjects in the order that they were added to the hash.
 *
 * @see JawaaObject
 * @see Iterator
 *
 * @author Pretesh Patel
 */
public class JawaaHash extends Hashtable implements Iterator
{
    public JawaaHash ()
    {
	myInstance = this;
	enum = new NameSpace();
    }

    public static JawaaHash getInstance ()
    {
	return myInstance;
    }

    public Object get (Object o)
    {
	String s = (String)o;
	int i = s.indexOf("[");
	int j = s.indexOf(".");

	if (i != -1)
	{
	    try
	    {
		JawaaContainer contain = (JawaaContainer)super.get(s.substring(0,i));
		StringParser parse = new StringParser(s.substring(i, s.length()), ".", false);
		if (parse.countTokens() == 1)
		{
		    return contain.get(Integer.parseInt(parse.nextToken()));
		}
		else if (parse.countTokens() == 2)
		{
		    return contain.get(Integer.parseInt(parse.nextToken()),
				       Integer.parseInt(parse.nextToken()));
		}
	    }
	    catch(Exception e)
	    {
	        ErrorHandler.error(this, "syntax error");
	    }
	}
	else if (j != -1)
	{
	    JawaaContainer contain = (JawaaContainer)super.get(s.substring(0,j));
	    StringParser parse = new StringParser(s.substring(j, s.length()), ".", false);
	    if (parse.countTokens() == 1)
	    {
		return contain.get(Integer.parseInt(parse.nextToken()));
	    }
	}

	return super.get(s);
    }

    public Object put (String s, Object o)
    {
	enum.addName(s);
	return super.put(s, o);
    }

    public Object remove (Object o)
    {
	String s = (String)o;

	init();
	while (hasNext())
	{
	    Drawable obj = (Drawable)next();
	    if (obj instanceof JawaaGroupObject)
	    {
		((JawaaGroupObject)obj).remove(s);
	    }
	}
	enum.removeName(s);
	Drawable obj = (Drawable)get(s);
	obj.destroy();
	return super.remove(s);
    }
    
    public void touchAll (Graphics g)
    {
	init();
	while(hasNext())
	{
	    ((Drawable)next()).paint(g);
	}
    }


    public void reset ()
    {
	clear();
	enum.reset();
    }

    public void init ()
    {
	enum.init();
    }

    public boolean hasNext ()
    {
	return enum.hasNext();
    }

    public Object next ()
    {
        return get((String)enum.next());
    }


    private NameSpace enum; 
    private static JawaaHash myInstance;
}
