/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           JawaaActionPerformer.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
This class is a base class for subclasses that wish to perform
JawaaActions and in doing so alert JawaaListeners.                              
-------------------------------------------------------------------------------*/
package jawaa.util;

import java.util.Vector;


public class JawaaActionPerformer
{
    protected JawaaActionPerformer ()
    {
	myListeners = new Vector();
    }


    public void addListener (JawaaListener listener)
    {
	myListeners.addElement(listener);
    }

    public void removeListener (JawaaListener listener)
    {
	myListeners.removeElement(listener);
    }

    public void fireActionPerformed ()
    {
	for (int i = 0; i < myListeners.size(); i++)
	{
	    ((JawaaListener)myListeners.elementAt(i)).actionPerformed();
	}
    }

    public void fireActionCompleted ()
    {
	for (int i = 0; i < myListeners.size(); i++)
	{
	    ((JawaaListener)myListeners.elementAt(i)).actionCompleted();
	}
    }


    private Vector myListeners;
}
