/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.structure;

import jawaa.anim.AnimController;
import jawaa.object.*;
import java.awt.*;
import jawaa.util.*;


public class JawaaQueue extends JawaaContainer
{
    public JawaaQueue(String[] args)
    {
	super(args);
    }

    public void build(String[] args)
	throws ArrayIndexOutOfBoundsException, NumberFormatException,
	       NullPointerException
    {
	myQueue = new Queue();
	myBuffer = 2;
	myMetric = AnimController.getFontMetrics();
	myLength = 2*myBuffer;
	myLocation = new Point(Integer.parseInt(args[2]),
			       Integer.parseInt(args[3]));
	myLength = Integer.parseInt(args[4]);
	String[] temp = new String[myLength];
	int i = 5;
	for(; i < myLength+5; i++)
	{
	    temp[i-5] = args[i];	   

	}
	setColor(args[i]);
	i++;
	setTextColor(args[i]);
	setBackground(args[i]);

	for(int j=temp.length-1; j>=0; j--)
	{
	     Point p = new Point(myLocation.x + myLength,
				myLocation.y + myMetric.getMaxAscent() +
				myBuffer);
	     myQueue.addElement(new JawaaText(temp[j], p, myTextColor));
	     myLength+=myMetric.stringWidth(temp[j])+2*myBuffer;
	}
    }

    public void paint(Graphics g)
    {
	int bottom_line =
	    myLocation.y+myMetric.getMaxAscent()+myMetric.getMaxDescent() + 2*myBuffer;
	
	
	g.setColor(myColor);
	g.drawLine(myLocation.x, myLocation.y,
		   myLocation.x+myLength,myLocation.y);
	
	g.drawLine(myLocation.x, bottom_line, myLocation.x+myLength,
		   bottom_line);
	super.paint(g);
    }

    public void init()
    {
	myQueue.init();
    }

    public boolean hasNext()
    {
	return(myQueue.hasNext());
    }

    public Object next()
    {
	return myQueue.next();
    }

    public void enqueue(String s)
    {
	myLength += myMetric.stringWidth(s) + 2*myBuffer;
	updateLocation(myMetric.stringWidth(s));
	Point p = new
	    Point(myLocation.x+myBuffer, myLocation.y+myBuffer+myMetric.getMaxAscent());
	myQueue.enqueue(new JawaaText(s, p, myTextColor));
    }

    public void dequeue()
    {
	String s = ((JawaaText)myQueue.dequeue()).getText();
	myLength -= myMetric.stringWidth(s);
    }

    public void updateLocation(int x)
    {
	myQueue.init();
	while(myQueue.hasNext())
	{
	    JawaaObject o = (JawaaObject)myQueue.next();
	    o.offsetLocation(x+myBuffer, 0);
	}
    }


    public void setColor(Color c)
    {
	myColor = c;
    }

    public void setBackground(Color c)
    {
	myBackground = c;
    }
    
        public void setTextColor(String color)
    {
	setTextColor(ColorFactory.getColor(color));
    }

    public void setTextColor(Color c)
    {
	super.setTextColor(c);
	init();
	while(hasNext())
	{
	   try{
	       ((JawaaObject)next()).setTextColor(c);
	    }
	    catch(ClassCastException e){
		
	    }
	}
    }
    
    public Color getTextColor()
    {
	return myTextColor;
    }
    
    
    private Queue myQueue;
    private int myBuffer = 2;
    private FontMetrics myMetric;
    private int myLength;
    private int myIndex;
}
